//
//  vAOTextViewAdditions.m
//  viAllOver
//
//  Copyright (c) 2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 

#import "vAOTextViewAdditions.h"
#import "vAOConstants.h"


@implementation vAOTextView (vAOTextViewAdditions)


// new commands

#pragma mark	-
#pragma mark	Modes

- (void)vAO_insertMode:(id)sender
{
	[[self sharedData] setCommandMode: FALSE];
	
	// turn off command recording
	//[[self sharedData] setRecordCommand: FALSE];

	// turn off visual mode
	[[self sharedData] setVisualMode: FALSE]; 

    [self setNeedsDisplay:YES];
	
}

- (void)vAO_commandMode:(id)sender;
{
	[[self sharedData] setCommandMode: TRUE];

    [self setNeedsDisplay:YES];
	
}

- (void)vAO_visualMode:(id)sender
{
	// turn on visual mode
	[[self sharedData] setVisualMode: @"v"]; 
	
	// select the character under the cursor for the start of our selection
	if ( [self selectedRange].length == 0 )
		[self setSelectedRange: NSMakeRange([self selectedRange].location, 1)];

//NSLog(@"visual mode");
	
	[self setNeedsDisplay:YES];

}

- (void)vAO_visualLineMode:(id)sender
{
	// turn on visual mode
	[[self sharedData] setVisualMode: @"V"]; 
	
	// set selections to line
	[self setSelectionGranularity:NSSelectByParagraph];
	
	// select the character under the cursor for the start of our selection
	[self setSelectedRange: NSMakeRange([self selectedRange].location, 1)];

	[self setNeedsDisplay:YES];
}


#pragma mark	-

- (void)vAO_replaceChar:(id)sender
{
	[[self sharedData] setSpecialMode: @"r"]; 
}

- (void)vAO_repeatLastEdit:(id)sender;
{
	// don't need to record anything now
	[[self sharedData] setRecordCommand: FALSE]; 
	
	// lock
	[[self sharedData] setRepeatingLastEdit: TRUE]; 
	
	NSString *lastCommand = [[self sharedData] recordedCommand];
	int i, commandCount = [lastCommand length];
	
NSLog(@"repeating: %@", lastCommand);
	for ( i = 0; i < commandCount; i++ )
	{
		[self insertText: [lastCommand substringWithRange: NSMakeRange(i,1)]];
	}
	
	// un-lock
	[[self sharedData] setRepeatingLastEdit: FALSE]; 

	// make sure we return to command mode
	[self vAO_commandMode: sender];
}

#pragma mark	-
#pragma mark	Paste

- (void)vAO_pasteBefore:(id)sender
{
	NSPasteboard *pb = [NSPasteboard generalPasteboard];
	
	NSString *lineCopy = [pb stringForType: viAllOverPasteboardType];
	
	if ( [lineCopy isEqualToString: @"YES"] )
	{
		[self doCommandBySelector:@selector(moveToBeginningOfLine:)];
	}
	
	[self doCommandBySelector:@selector(paste:)];

}

- (void)vAO_pasteAfter:(id)sender
{
	NSPasteboard *pb = [NSPasteboard generalPasteboard];
	
	NSString *lineCopy = [pb stringForType: viAllOverPasteboardType];
	
	if ( [lineCopy isEqualToString: @"YES"] )
	{
		[self doCommandBySelector:@selector(moveDown:)];
		[self doCommandBySelector:@selector(moveToBeginningOfLine:)];
	}
	else
	{
		[self doCommandBySelector:@selector(moveForward:)];
	}
	
	[self doCommandBySelector:@selector(paste:)];

}

#pragma mark	-
#pragma mark	Go To

- (void)vAO_goTo:(id)sender
{	
	[self vAO_goTo: sender andModifySelection: NO];
}

- (void)vAO_goToAndModifySelection:(id)sender
{	
	[self vAO_goTo: sender andModifySelection: YES];
}

- (void)vAO_goTo:(id)sender andModifySelection: (BOOL) modify;
{	
//NSLog(@"goTo: %d", [[self sharedData] repeatTimes]);

	if ( [[self sharedData] repeatTimes] > 0 )
	{	
//NSLog(@"go to line: %d", [[self sharedData] repeatTimes]);

		unsigned int l = [self getIndexForLineNumber: [[self sharedData] repeatTimes]];
		
		[[self sharedData] setRepeatTimes: 0];
//NSLog(@"char at index: %d", l);
		
		// go to the line index
		NSRange r = NSMakeRange(l, 0);
		//[self setSelectedRange: r];
		[self select_new_Range: r forSelectionModification: modify];
		[self scrollRangeToVisible: r];
	}
	else
	{
//NSLog(@"going to end of doc.");
		[self doCommandBySelector:@selector(moveToEndOfDocument:)];
		[self doCommandBySelector:@selector(moveToBeginningOfLine:)];
	}
}

// thank you "vi Input Manager Plugin" - http://www.corsofamily.net/jcorso/vi/
- (int)getIndexForLineNumber:(int)number;
{
	unsigned numberOfLines, index, stringLength = [[self string] length];
	
	if (number == 1)
		return 0;

	for (index = 0, numberOfLines = 1; (index < stringLength) && (numberOfLines < number); numberOfLines++)
	{	
		index = NSMaxRange([[self string] lineRangeForRange:NSMakeRange(index, 0)]);
	}
			
	return index;
}


#pragma mark	-
#pragma mark	Line Find

- (void)vAO_lineFindForward:(id)sender
{
	[[self sharedData] setSpecialMode: @"f"]; 
}

- (void)vAO_lineFindForwardAndModifySelection:(id)sender
{
	[[self sharedData] setSpecialMode: @"f"]; 
}

- (void)vAO_lineFindBackward:(id)sender
{
	[[self sharedData] setSpecialMode: @"F"]; 
}

- (void)vAO_lineFindBackwardAndModifySelection:(id)sender
{
	[[self sharedData] setSpecialMode: @"F"]; 
}

- (void)vAO_lineFindMinus1Forward:(id)sender
{
	[[self sharedData] setSpecialMode: @"t"]; 
}

- (void)vAO_lineFindMinus1ForwardAndModifySelection:(id)sender
{
	[[self sharedData] setSpecialMode: @"t"]; 
}

- (void)vAO_lineFindMinus1Backward:(id)sender
{
	[[self sharedData] setSpecialMode: @"T"]; 
}

- (void)vAO_lineFindMinus1BackwardAndModifySelection:(id)sender
{
	[[self sharedData] setSpecialMode: @"T"]; 
}

- (void)vAO_repeatLastLineFind:(id)sender;
{
	NSString *lastFind = [[self sharedData] lastLineFind];
	
//NSLog(@"last line find: %@", lastFind);
	if ( nil != lastFind )
	{
		unichar oldChar = [lastFind characterAtIndex: 0];
		[self insertText: [NSString stringWithFormat: @"%c", oldChar]]; 
		[self insertText: [NSString stringWithFormat: @"%c", [lastFind characterAtIndex: 1]]];
	}
	else
		NSBeep();
}

- (void)vAO_repeatLastLineFindInOppositeDirection:(id)sender;
{
	NSMutableString *lastFind = [[[self sharedData] lastLineFind] mutableCopy];
	
	if ( nil != lastFind )
	{
		unichar oldChar = [lastFind characterAtIndex: 0];
		[self insertText: [NSString stringWithFormat: @"%c", [self getOppositeCase: oldChar]]]; 
		[self insertText: [NSString stringWithFormat: @"%c", [lastFind characterAtIndex: 1]]];
	}
	else
		NSBeep();
}

#pragma mark	-
#pragma mark	Change Case

- (void)changeCaseOfLetter:(id)sender
{
	NSRange lookHere = [self selectedRange];
	
	if ( lookHere.length < 1 )
	{
		lookHere.length = 1;
		[self setSelectedRange: lookHere];
	}
	
	NSMutableString *newString = [NSMutableString string];
	int i;
	
	for ( i = 0; i < lookHere.length; i++ )
	{
		[newString appendFormat: @"%c", [self getOppositeCase: [[self string] characterAtIndex: lookHere.location + i]]];
	}
	
	[self insertTextNow: newString];
}

- (unichar) getOppositeCase: (unichar) orig;
{
	unichar new = orig;
	unichar diff = 'a' - 'A';
	
	if ( orig >= 'a' && orig <= 'z' )
		new = orig - diff;
	else if ( orig >= 'A' && orig <= 'Z' )
		new = orig + diff;

	return new;
}

#pragma mark	-
#pragma mark	Find Support

-(void)vAO_openFindPanel:(id)sender;
{
	NSControl *c = [[NSControl alloc] initWithFrame:NSZeroRect];
	[c setTag: NSFindPanelActionShowFindPanel];
	[self performFindPanelAction: c];
	[c release];
}

-(void)vAO_findNext:(id)sender;
{
	NSControl *c = [[NSControl alloc] initWithFrame:NSZeroRect];
	[c setTag: NSFindPanelActionNext];
	[self performFindPanelAction: c];
	[c release];
}

-(void)vAO_findPrevious:(id)sender;
{
	NSControl *c = [[NSControl alloc] initWithFrame:NSZeroRect];
	[c setTag: NSFindPanelActionPrevious];
	[self performFindPanelAction: c];
	[c release];
}

-(void)vAO_findNextSelection:(id)sender;
{
	NSRange lookHere = [self selectedRange];

	if ( lookHere.length == 0 )
	{
		// no selection, select the word under the cursor
		NSRange newSelection = [self selectionRangeForProposedRange:lookHere granularity:NSSelectByWord];
		[self setSelectedRange:newSelection];
	}
		
	NSControl *c = [[NSControl alloc] initWithFrame:NSZeroRect];
	[c setTag: NSFindPanelActionSetFindString];
	[self performFindPanelAction: c];
	[c release];
	
	[self vAO_findNext:nil];
}

-(void)vAO_findPreviousSelection:(id)sender;
{
	NSRange lookHere = [self selectedRange];

	if ( lookHere.length == 0 )
	{
		// no selection, select the word under the cursor
		NSRange newSelection = [self selectionRangeForProposedRange:lookHere granularity:NSSelectByWord];
		[self setSelectedRange:newSelection];
	}
		
	NSControl *c = [[NSControl alloc] initWithFrame:NSZeroRect];
	[c setTag: NSFindPanelActionSetFindString];
	[self performFindPanelAction: c];
	[c release];
	
	[self vAO_findPrevious:nil];
}

#pragma mark	-
#pragma mark	Word Movement

// for implementing "w"
// words delimited by spaces, newlines, and punction
- (void)vAO_wordForward:(id)sender;
{
	[self vAO_wordMovementModifySelection: NO ignorePunctuation: NO];
}

- (void)vAO_wordForwardAndModifySelection:(id)sender;
{
	[self vAO_wordMovementModifySelection: YES ignorePunctuation: NO];
}

// for implementing "W"
// words delimited by spaces or newlines only
- (void)vAO_wordForwardIgnorePunctuation:(id)sender
{
	[self vAO_wordMovementModifySelection: NO ignorePunctuation: YES];
}

- (void)vAO_wordForwardIgnorePunctuationAndModifySelection:(id)sender;
{
	[self vAO_wordMovementModifySelection: YES ignorePunctuation: YES];
}

// for implementing "b"
- (void)vAO_wordBackward:(id)sender
{
	[self vAO_wordMovementModifySelection: NO ignorePunctuation: NO backward: YES];
}

- (void)vAO_wordBackwardAndModifySelection:(id)sender;
{
	[self vAO_wordMovementModifySelection: YES ignorePunctuation: NO backward: YES];
}

// for implementing "B"
- (void)vAO_wordBackwardIgnorePunctuation:(id)sender
{
	[self vAO_wordMovementModifySelection: NO ignorePunctuation: YES backward: YES];
}

- (void)vAO_wordBackwardIgnorePunctuationAndModifySelection:(id)sender;
{
	[self vAO_wordMovementModifySelection: YES ignorePunctuation: YES backward: YES];
}

// for implementing "e"
- (void)vAO_wordForwardToEnd:(id)sender;
{
	[self vAO_wordMovementModifySelection: NO ignorePunctuation: NO backward: NO moveToEnd: YES];
}

- (void)vAO_wordForwardToEndAndModifySelection:(id)sender;
{
	[self vAO_wordMovementModifySelection: YES ignorePunctuation: NO backward: NO moveToEnd: YES];
}

// for implementing "E"
- (void)vAO_wordForwardToEndIgnorePunctuation:(id)sender
{
	[self vAO_wordMovementModifySelection: NO ignorePunctuation: YES backward: NO moveToEnd: YES];
}

- (void)vAO_wordForwardToEndIgnorePunctuationAndModifySelection:(id)sender;
{
	[self vAO_wordMovementModifySelection: YES ignorePunctuation: YES backward: NO moveToEnd: YES];
}


- (void)vAO_wordMovementModifySelection: (bool)modify ignorePunctuation: (BOOL)ignore;
{
	[self vAO_wordMovementModifySelection:modify ignorePunctuation:ignore backward: false];
}

- (NSRange)getCurrentWordIgnorePunctuation: (BOOL)ignore;
{
	return [self getCurrentWordIgnorePunctuation:ignore range: [self selectedRange]];
}

- (NSRange)getCurrentWordIgnorePunctuation: (BOOL)ignore range: (NSRange)startHere;
{
	NSMutableCharacterSet * notWordSet = [[NSCharacterSet whitespaceAndNewlineCharacterSet] mutableCopy];
	
	NSMutableCharacterSet * puncSet = [[NSCharacterSet punctuationCharacterSet] mutableCopy];
	[puncSet formUnionWithCharacterSet: [NSCharacterSet symbolCharacterSet]];
	
	NSCharacterSet * wordSet = [notWordSet invertedSet];

	
	if ( !ignore ) // not ignoring punctuation
	{
		[notWordSet formUnionWithCharacterSet: puncSet];
	}
	
	
	unsigned int strLength = [[self string] length];
	NSRange lookHere = startHere;
	NSRange itsHere = NSMakeRange(NSNotFound,0);
	BOOL zero = NO;
	
if (DEBUG) NSLog(@"word here?: %@", NSStringFromRange(startHere));
	
	if ( startHere.location >= 0 && startHere.location < strLength && [wordSet characterIsMember: [[self string] characterAtIndex: startHere.location]] )
	{
		NSCharacterSet *notSet;
		
		// what set is this word in
		if ( !ignore && [puncSet characterIsMember: [[self string] characterAtIndex: startHere.location]] )
		{
//NSLog(@"this is punc.");			
			notSet = [puncSet invertedSet];
		}
		else
			notSet = notWordSet;
		
//NSLog(@"in a word");
		// find the beggining of the word
		BOOL alreadyHere = true;
		
		
		while (  ![notSet characterIsMember: [[self string] characterAtIndex: lookHere.location]] )
		{
			alreadyHere = false;
			
			if ( lookHere.location == 0 ) 
			{
				zero = YES;
				break;
			}
							
//NSLog(@" not here: %@", NSStringFromRange(lookHere));
			lookHere.location -= 1;
//NSLog(@" look here: %@", NSStringFromRange(lookHere));

		}
		
//NSLog(@" look here: %@", NSStringFromRange(lookHere));
		if ( zero )
			itsHere.location = 0;
		else if ( alreadyHere )
			itsHere.location = lookHere.location;
		else
			itsHere.location = lookHere.location + 1;
		
//NSLog(@" that starts here: %@", NSStringFromRange(itsHere));
		lookHere = startHere;
		
		// find the end of the word
		while ( lookHere.location < strLength && ![notSet characterIsMember: [[self string] characterAtIndex: lookHere.location]] )
		{
//NSLog(@" not here: %@", NSStringFromRange(lookHere));
			lookHere.location += 1;
		}
//NSLog(@" that ends here: %@", NSStringFromRange(lookHere));
		
		itsHere.length = lookHere.location - itsHere.location;
		
		if ( itsHere.length == 0 )
			itsHere.length = 1;
			
//NSLog(@"found word here: %@", NSStringFromRange(itsHere));
	}

	[notWordSet release];
	[puncSet release];
	
	return itsHere;
}

- (void)vAO_wordMovementModifySelection: (bool)modify ignorePunctuation: (BOOL)ignore backward: (BOOL)backward;
{
	[self vAO_wordMovementModifySelection: modify ignorePunctuation: ignore backward: backward moveToEnd: FALSE];
}

- (void)vAO_wordMovementModifySelection: (bool)modify ignorePunctuation: (BOOL)ignore backward: (BOOL)backward moveToEnd: (BOOL)end;
{
	unsigned int strLength = [[self string] length];
	unsigned searchMask = NSCaseInsensitiveSearch;
	NSRange startHere;
	NSRange theWord;
	NSRange here;
	
	startHere = here = [self selectedRange];
	
	if ( modify )
	{
		if ( backward )
		{
			startHere.location = startHere.location - 1;
		}
		else
		{
			startHere.location = startHere.location + startHere.length;
		}
		
		startHere.length = 1;
	}
	
	theWord = [self getCurrentWordIgnorePunctuation:ignore range: startHere];
	
//if ( DEBUG ) NSLog(@"theWord: %@", NSStringFromRange(theWord));
	if ( theWord.location != NSNotFound ) 
	{
		/*if ( backward )
		{
			startHere.location = theWord.location - 1;
		}
		else
		{
			startHere.location = theWord.location + theWord.length;
		}*/
		startHere = theWord;
//NSLog(@"look for next word here: %@", NSStringFromRange(startHere));
	}
	else
		startHere = [self selectedRange];

	if ( backward )
	{
		startHere.location = startHere.location - 1;
	}
	else
	{
		startHere.location = startHere.location + startHere.length;
	}
	startHere.length = 1;
	
	
//NSLog(@"theWord.loc: %@, here.loc %@, backward: %d, end: %d", NSStringFromRange(theWord), NSStringFromRange(here), backward, end );
	if ( 
		( !backward && !end ) || 
		( backward && ( theWord.location != NSNotFound && theWord.location == here.location ) || theWord.location == NSNotFound) ||
		( end && ( theWord.location != NSNotFound && theWord.location + theWord.length - 1 == here.location ) || theWord.location == NSNotFound) 
	)
	{
		// find the next word
		do
		{
//NSLog(@"looking for next word here: %@", NSStringFromRange(startHere));
			theWord = [self getCurrentWordIgnorePunctuation:ignore range: startHere];

			if ( backward )
				startHere.location -= 1;
			else
				startHere.location += 1;
			
			if ( startHere.location < 0 || startHere.location > strLength )
			{
				// don't want to go off the end
				break;
			}
		}
		while ( theWord.location == NSNotFound ) ;
	}
	
	if ( theWord.location == NSNotFound ) 
	{
		// no more words, go to the end/beginning
		if ( backward )
			[self select_new_Range: NSMakeRange(0, 1) forSelectionModification: modify];
		else
			[self select_new_Range: NSMakeRange(strLength, 1) forSelectionModification: modify];
	}
	else
	{
		// which part of the word to go to
		if ( end )
		{
			// the end
			theWord.location = theWord.location + theWord.length - 1;
		}
		else
		{
			// begginning
		}
		
		theWord.length = 0;

		[self select_new_Range:theWord forSelectionModification:modify];
	}

}

#pragma mark	-
#pragma mark	first character

- (void)vAO_moveToFirstCharacter:(id)sender
{	
	[self doCommandBySelector: @selector(moveToBeginningOfLine:)];
	
	NSRange startHere = [self selectedRange];

	// word forward if first char is white space
	if ( [[NSCharacterSet whitespaceCharacterSet] characterIsMember: [[self string] characterAtIndex: startHere.location]] )
	{
		[self doCommandBySelector: @selector(vAO_wordForward:)];
	}
	
}

#pragma mark	-
#pragma mark	join lines

- (void)vAO_joinLines:(id)sender
{	
	[self doCommandBySelector: @selector(moveToEndOfLine:)];
	
	NSRange startHere = [self selectedRange];

	if ( startHere.location > 0 )
	{
		// add a space if we need one
//NSLog(@"check char: %c", [[self string] characterAtIndex: startHere.location - 1]);

		if ( [[self string] characterAtIndex: startHere.location - 1] != ' ' )
		{
//NSLog(@"insert space");
			//[[self sharedData] setCommandMode: FALSE];
			[self insertTextNow: @" "];
			//[[self sharedData] setCommandMode: TRUE];
		}
	}

	// remove the newline
	startHere = [self selectedRange];
	startHere.length = 1;
	[self setSelectedRange: startHere];
	[self doCommandBySelector: @selector(vAO_wordForwardAndModifySelection:)];
	[self doCommandBySelector: @selector(delete:)];

}

#pragma mark -
#pragma mark end

@end
