//
//  vAOTextView.m
//  viAllOver
//
//  Copyright (c) 2004-2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 



#import "vAOTextView.h"
#import "vAOScrollView.h"
#import "vAOConstants.h"
#import "vAOPrefs.h"
//#import <WebKit/WebFrameLoadDelegate.h>

#define LOG_LOADING NO

@implementation vAOTextView

+ (void)load
{
	// check for apps to exclude			

	NSBundle * b = [NSBundle mainBundle];

	NSString *appPath = [b bundlePath];
	NSString *appIdentifier = [b bundleIdentifier];

	NSArray *appPathParts = [appPath pathComponents];
	
	//NSString *appName = [[appPathParts objectAtIndex: [appPathParts count] - 1] stringByDeletingPathExtension];
	NSString *appName = [[appPathParts lastObject] stringByDeletingPathExtension];

	//NSDictionary *thisApp = [NSDictionary dictionaryWithObjectsAndKeys: appName, @"name", appIdentifier, @"id", nil];
	
	int count = 19;
	
	NSString *logString = [NSString stringWithFormat: @"viAllOver is trying to load for %@ (%@)", appName, appIdentifier];
	NSLog(logString);

	if ( LOG_LOADING )
	{
		NSFileHandle *fh = [NSFileHandle fileHandleForWritingAtPath: @"/Users/Shared/viallover.log"];
		[fh seekToEndOfFile];
		//NSLog(@"fh: %@", fh);

		NSString *shortLogString = [NSString stringWithFormat: @"[%d] %@ (%@)", count, appName, appIdentifier];
		//const char *utfString = [[shortLogString stringByAppendingFormat: @"\n"] UTF8String];
		const char *utfString = [shortLogString UTF8String];
		NSData *myData = [NSData dataWithBytes: utfString length: strlen(utfString)];

		[fh writeData: myData];
		//[fh synchronizeFile];
	}
	
	NSArray *defaultExcludes = [[vAOPrefs defaults] valueForKey: excludedAppsKey];
	NSArray *excludes = [[[vAOPrefs sharedPrefs] valueForKey: excludedAppsKey] arrayByAddingObjectsFromArray: defaultExcludes];
	
//NSLog(@"user excludes: %@", excludes);
	NSEnumerator *enumer = [excludes objectEnumerator];
	NSDictionary *dict = nil;
	while ( dict = [enumer nextObject] )
	{
		if ( ( appIdentifier != nil && [dict objectForKey:@"id"] != nil && [[dict objectForKey:@"id"] isEqualTo:appIdentifier] ) ||
			( appName != nil && [dict objectForKey:@"name"] != nil && [[dict objectForKey:@"name"] isEqualTo:appName] ) )
		{

			if ( LOG_LOADING )
			{
				NSFileHandle *fh = [NSFileHandle fileHandleForWritingAtPath: @"/Users/Shared/viallover.log"];
				[fh seekToEndOfFile];

				NSString *shortLogString = [NSString stringWithFormat: @" excluded."];
				const char *utfString = [[shortLogString stringByAppendingFormat: @"\n"] UTF8String];
				NSData *myData = [NSData dataWithBytes: utfString length: strlen(utfString)];

				[fh writeData: myData];

				[fh closeFile];
			}

			return;
			break;
		}
	
	}
	
	NSLog(@"loading vAOTextView");

	if ( LOG_LOADING )
	{
		NSFileHandle *fh = [NSFileHandle fileHandleForWritingAtPath: @"/Users/Shared/viallover.log"];
		[fh seekToEndOfFile];

		NSString *shortLogString = [NSString stringWithFormat: @" loaded."];
		const char *utfString = [[shortLogString stringByAppendingFormat: @"\n"] UTF8String];
		NSData *myData = [NSData dataWithBytes: utfString length: strlen(utfString)];

		[fh writeData: myData];

		[fh closeFile];
	}
	
	// time to take over the world
	[[self class] poseAsClass:[NSTextView class]];	
	
	
	// attempt to do some less-style scrolling
	if ( [[vAOPrefs sharedPrefs] boolForKey: @"useMovementKeysInScrollViews"] )
	{
		NSLog(@"loading vAOScrollView");
		// attempting to make scrolling work
		[[vAOScrollView class] poseAsClass:[NSScrollView class]];		
	}
    
}

- (id)initWithFrame:(NSRect)frameRect
{
	self = [super initWithFrame:frameRect];
	
    if (self) 
	{
        // Initialization code here.
		
NSLog(@"Start in command mode: %d", [[vAOPrefs sharedPrefs] boolForKey: @"startInCommandMode"]);
		if ( [[vAOPrefs sharedPrefs] boolForKey: @"startInCommandMode"] )
			[[self sharedData] setCommandMode: YES];
		else
			[[self sharedData] setCommandMode: NO];
		
		// visual mode off
		[[self sharedData] setVisualMode: FALSE];
		
		[[self sharedData] setRepeatTimes: 0];
		
		[[self sharedData] setInsertionPointLock: FALSE];

	}
	
    return self;
	
}

- (void)keyDown:(NSEvent *)theEvent
{
	if ( ![[vAOPrefs sharedPrefs] boolForKey: @"enabled"] )
		return [super keyDown: theEvent];
		
    // print keyCodes in the textview
    //[super insertText: [[NSNumber numberWithUnsignedShort: [theEvent keyCode]] stringValue]];
	
	BOOL modifiers = FALSE;

    if ( ([theEvent modifierFlags] & NSAlphaShiftKeyMask) ||
		 ([theEvent modifierFlags] & NSShiftKeyMask) ||
		 ([theEvent modifierFlags] & NSControlKeyMask) ||
		 ([theEvent modifierFlags] & NSAlternateKeyMask) ||
		 ([theEvent modifierFlags] & NSCommandKeyMask) ) {
		
		modifiers = TRUE;
	}

    // need to check for escape key here, so we can switch modes
	// [esc] keyCode -> 53
    if ( [theEvent keyCode] == 53 && !modifiers )
    {
		// switch to command mode
		[[self sharedData] setCommandMode: TRUE];
		
		// turn off visiual mode
		[[self sharedData] setVisualMode: FALSE];
		
		// turn off command recording
		[[self sharedData] setRecordCommand: FALSE];
		//[[self sharedData] resetRecordedCommand];
		
		// clear the repeat times
		[[self sharedData] setRepeatTimes: 0];
		
		// clear the command
		[[self sharedData] setCommand: nil];
		
		[self setNeedsDisplay:YES];
    }
	else if ( [theEvent keyCode] == 51 && !modifiers ) // backspace
	{
		if ( [[self sharedData] commandMode] )
		{
			[self doCommandBySelector: @selector(moveLeft:)];
		}
		else
		{
			if ( [[self sharedData] recordCommand] )
			{
				// pop the last char added
				[[self sharedData] popFromRecordedCommand];
				
			}

			// send the backspace to the field
			[super keyDown: theEvent];
		}
	}
    else
    {
		[super keyDown: theEvent];
    }
}

- (void)insertText:(id)aString
{   
	if ( ![[vAOPrefs sharedPrefs] boolForKey: @"enabled"] )
		return [super insertText: aString];

//if (DEBUG) NSLog(@"key: %@, recording: %d", aString,  [[self sharedData] recordCommand]);

	if ( [[self sharedData] recordCommand] )
	{
		[[self sharedData] addToRecordedCommand: aString];
	}
	
    if ( [[self sharedData] isSpecialMode: @"r"] )
    {
		//NSLog(@"got the replace char");
		
		// get number of times to repeat
		int times = [[self sharedData] repeatTimes];
		int i, rt = (times)?times:1 ;
		
		// now repeat
		for ( i = 0; i < rt; i++ )
		{
			// select the next character to the right
			[self doCommandBySelector: @selector(moveRightAndModifySelection:)];
			
			// replace selected character with new one from user
			[super insertText: aString];
		}
		
		// turn off replace mode
		[[self sharedData] setSpecialMode: @""];
		[[self sharedData] setRepeatTimes: 0];
		
		return;
	}
		
    if ( [[self sharedData] isSpecialMode: @"f"] || [[self sharedData] isSpecialMode: @"F"] || 
		[[self sharedData] isSpecialMode: @"t"] || [[self sharedData] isSpecialMode: @"T"] )
    {
		NSString *findThis = aString;
		NSString *findMode = [[self sharedData] specialMode];

		// save the find
		NSString *lastFind = [[[self sharedData] specialMode] stringByAppendingString: findThis];
		[[self sharedData] setLastLineFind: lastFind];
		
if (DEBUG) NSLog(@"searching for: %@", findThis);
		BOOL modify = false;
		BOOL backward = false;
		unsigned searchMask = 0;
		unsigned int strLength = [[self string] length];
		
		// get number of times to repeat
		int times = [[self sharedData] repeatTimes];
		int i, rt = (times)?times:1 ;
		
		if ( [[self sharedData] isSpecialMode: @"F"] ||
			[[self sharedData] isSpecialMode: @"T"] )
		{
if (DEBUG) NSLog(@"backwards");
			backward = true;
			searchMask |= NSBackwardsSearch;
		}
		
if (DEBUG) NSLog(@"command: %@", [[self sharedData] command]);
		if ( [[self sharedData] visualMode] )
			modify = TRUE;
		else if ( [[self sharedData] command] )
		{
//NSLog(@"setting mark");
			//[self setMark:nil];
			modify = TRUE;
		
		}
			
		NSRange lookHere = [self get_new_lookHere_location_forSelectionModification: modify backward: backward];

		// now repeat
		for ( i = 0; i < rt; i++ )
		{
			lookHere.location += 1;
			lookHere.length -= 1;
///* if (DEBUG) */ NSLog(@"%d.1 lookHere: %@", i, NSStringFromRange(lookHere));
			
			lookHere = [[self string] rangeOfString: findThis options: searchMask range: lookHere];
		
///* if (DEBUG) */ NSLog(@"%d.2 lookHere: %@", i, NSStringFromRange(lookHere));
			if ( lookHere.location != NSNotFound ) 
			{
				
				if ( [[self sharedData] isSpecialMode: @"t"] && i == rt - 1)
				{
///* if (DEBUG) */ NSLog(@"tee");
					lookHere.location -= 1;
				} else if ( [[self sharedData] isSpecialMode: @"T"] && i == rt - 1)
				{
///* if (DEBUG) */ NSLog(@"TEE");
					lookHere.location += 1;
				}
				
				[self select_new_Range: lookHere forSelectionModification: modify];
				
				if ( backward )
				{
					lookHere.length = lookHere.location;
					lookHere.location = 0;
				}
				else
					lookHere.length = strLength - lookHere.location;
			}
			else
			{
				// not found, we should probably beep
				NSBeep();
			}
		}
		
		// turn off replace mode
		[[self sharedData] setSpecialMode: @""];
		[[self sharedData] setRepeatTimes: 0];

		if ( [[self sharedData] command] )
		{
if (DEBUG) NSLog(@"going to run the command");
			//[self selectToMark:nil];
			//[self vAO_visualMode:nil];
			[[self sharedData] setVisualMode: @"v"]; 
			vAOCommand *theCommand = [[self sharedData] command];
			[[self sharedData] setCommand: NULL];
			[theCommand doItTo:self];
			[[self sharedData] setVisualMode: FALSE]; 
		}
		
		return;
	}
		
	if ( [[self sharedData] commandMode] )
	{	    
	    // check for new lines and forget them
	    if ( [aString isEqualToString: @"\n"] )
	    {
			//[super insertText: aString];
		    return;
	    }

		// check for repeat numbers
	    if ( [aString intValue] > 0 || 
			 ( [[self sharedData] repeatTimes] > 0 && [aString isEqualToString: @"0"]) )
	    {
		    // it's a number, add prevous digits togeather
		    [[self sharedData] setRepeatTimes: 
				(10 * [[self sharedData] repeatTimes]) + [aString intValue]];

		    //NSLog(@"[COMMAND] %d", [[self sharedData] repeatTimes]);

		    return;
	    }
	    
	    // we are always going to repeat at least once
	    //if ( [[self sharedData] repeatTimes] < 1 ) {
		//    [[self sharedData] setRepeatTimes: 1];
	    //}
		
		// try and make a new cammand from the character
		vAOCommand * newCmd = [vAOCommand alloc];
		if (  [newCmd initAndDoItTo: self withChar: aString] ) 
		{
			return;
		}
		
		BOOL nix_command = ![newCmd isLineFind];
			
		
		//NSLog(@"done commanding.");
	    
	    // all done, reset repeatTimes, only if not a line find
		if ( ![newCmd isLineFind] )
			[[self sharedData] setRepeatTimes: 0];
			
		[newCmd release];
		
		if ( nix_command )
			[[self sharedData] setCommand: NULL];
		
		//[[self sharedData] setRecordCommand:NO];
		//[[self sharedData] resetRecordedCommand];

	}
    else
    {
		// not in command mode, just insert the characters normaly.
		[super insertText: aString];
    }
}

// aviod our insertText menthod
- (void) insertTextNow: (NSString *) str;
{
//NSLog(@"inserting string '%@'", str);
	[super insertText: str];
}



#pragma mark	-
#pragma mark Insertion Point Modification

- (void)drawViewBackgroundInRect:(NSRect)aRect
{
	if ( ![[vAOPrefs sharedPrefs] boolForKey: @"enabled"] )
		return [super drawViewBackgroundInRect: aRect];
	
	if ( [[vAOPrefs sharedPrefs] boolForKey: @"noInsertionPointModificationInInsertMode"] && ![[self sharedData] commandMode] )
		return [super drawViewBackgroundInRect: aRect];
	
	//NSLog(@"drawViewBackgroundInRect: %@", NSStringFromRect(aRect));
	
	[super drawViewBackgroundInRect: aRect];
	
	// now draw our insertion point behind the text
	NSRect caretRect = [self getInsertionPointRect];
	if ( ![self isHidden] && [self isEditable] && NSIntersectsRect(aRect, caretRect) ) 
	{
		[self drawInsertionPointInRect: caretRect color: [self insertionPointColor] turnedOn: TRUE];
	}
}

- (void)updateInsertionPointStateAndRestartTimer:(BOOL)flag 
{
	if ( ![[vAOPrefs sharedPrefs] boolForKey: @"enabled"] )
		return [super updateInsertionPointStateAndRestartTimer: flag];
		
	if ( [[vAOPrefs sharedPrefs] boolForKey: @"noInsertionPointModificationInInsertMode"] && ![[self sharedData] commandMode] )
		return [super updateInsertionPointStateAndRestartTimer: flag];

	if ( [self canDraw] && ![[self sharedData] insertionPointLock]) {		
		
		// we need to have lock because the "textContainerOrigin" method seem to 
		// make "updateInsertionPointStateAndRestartTimer" get called.
		[[self sharedData] setInsertionPointLock: TRUE];
		
		// have the insertion point updated next time
		[self setNeedsDisplayInRect: [self getInsertionPointRect]];
		
		// the following fixed a redraw problem, where the old cursor wasn't getting cleared
		[self setNeedsDisplayInRect: [[self sharedData] oldInsertionPointRect]];
		
		[[self sharedData] setInsertionPointLock: FALSE];
	}
}

- (NSRect)getInsertionPointRect 
{
	unsigned int here = [self selectedRange].location;
	int strLen = [[self string] length];
	
	//NSLog(@"checking here: %d", here);
	
	//NSLog(@"inset: %@", NSStringFromSize([self textContainerInset]));
	//NSLog(@"origin: %@", NSStringFromPoint([self textContainerOrigin]));
	
	NSRect caretRect = NSZeroRect;
	
	
	static NSMutableCharacterSet *newLineCharSet = nil;
	if ( nil == newLineCharSet )
	{
		newLineCharSet = [[NSCharacterSet whitespaceAndNewlineCharacterSet] mutableCopy];
		NSCharacterSet *notWhitespaceCharSet = [[NSCharacterSet whitespaceCharacterSet] invertedSet];
		[newLineCharSet formIntersectionWithCharacterSet: notWhitespaceCharSet];
	}
		
//NSLog(@"newlines: %@", newLineCharSet);
//NSLog(@"newline: %d", [newLineCharSet characterIsMember:'\n']);
//NSLog(@"other: %d", [newLineCharSet characterIsMember:'x']);
//NSLog(@"space: %d", [newLineCharSet characterIsMember:' ']);
	
	if ( strLen == 0 ) 
	{
		// empty textview
		caretRect = [self getStandardInsertionPointRect];
	} 
	else if ( here == strLen ) 
	{
		// when we are at the end of the line.

		here = here - 1;

		//NSLog(@"at the end of the line.");

//NSLog(@"char: %d", (unsigned int)[[self string] characterAtIndex: here]);

		//if ( [[self string] characterAtIndex: here] == '\n' ) 
		if ( [newLineCharSet characterIsMember: [[self string] characterAtIndex: here] ] ) 
		{
			//NSLog(@"newline here");
			// on a new line
			caretRect = [self getStandardInsertionPointRect];
		}
		else 
		{

			NSRect charBox = [self rectForCharacterIndex: here];

			// draw the caret in the next slot over
			charBox.origin.x = charBox.origin.x + charBox.size.width;
			charBox.size.width = [self getDefaultCaretWidth];
			
			caretRect = charBox;
		}
		
	} 
	else if ( here >= 0 && here < strLen ) 
	{
		// any where in the middle of the string

		NSRect charBox = [self rectForCharacterIndex: here];
		
		if ( [newLineCharSet characterIsMember: [[self string] characterAtIndex: here] ] ) 
		{
			//NSLog(@"newline here 2");
			// see if prevous char was a newline ask the layout mananger where to draw
			charBox.size.width = [self getDefaultCaretWidth];
		}
		else if ( NSIsEmptyRect(charBox) ) 
		{
			charBox = [[self layoutManager] extraLineFragmentUsedRect];
		} 
//NSLog(@"char: %d, %@", (unsigned int)[[self string] characterAtIndex: here], NSStringFromRect(charBox));
		
		if ( charBox.size.width == 0 )
			charBox.size.width = [self getDefaultCaretWidth];
			
		caretRect = charBox;
	}
	
	//[newLineCharSet release];
	
	return NSOffsetRect(caretRect, [self textContainerOrigin].x, [self textContainerOrigin].y);
}

- (NSRect)getStandardInsertionPointRect
{
	NSRect r = [[self layoutManager] extraLineFragmentUsedRect];
	
	// get the real insertion point
	r.origin.x = r.origin.x + ( r.size.width / 2 );
	
	r.size.width = [self getDefaultCaretWidth];
	
	return r;
}

- (int)getDefaultCaretWidth
{
	// we need to come up with a way to look this up based one the font.
	// but this is perfect in smultron and xcode (fixed width)
	return  6;
}

- (void)drawInsertionPointInRect:(NSRect)aRect color:(NSColor *)aColor turnedOn:(BOOL)flag 
{	
	if ( ![[vAOPrefs sharedPrefs] boolForKey: @"enabled"] )
		return [super drawInsertionPointInRect: aRect color: aColor turnedOn: flag];
		
	if ( [[vAOPrefs sharedPrefs] boolForKey: @"noInsertionPointModificationInInsertMode"] && ![[self sharedData] commandMode] )
		return [super drawInsertionPointInRect: aRect color: aColor turnedOn: flag];

	// have the old one cleared
	[self setNeedsDisplayInRect: [[self sharedData] oldInsertionPointRect]];
	
	// a nice transparent color
	[[aColor colorWithAlphaComponent: [[vAOPrefs sharedPrefs] floatForKey: @"insertionPointAlpha"]] set];
	
	//NSLog(@"drawing insertion point at: %@", NSStringFromRect(aRect));
	
	// accually draw the caret
	[[NSBezierPath bezierPathWithRect: aRect] fill];
	
	// save the old one so we can make sure it has been cleared
	[[self sharedData] setOldInsertionPointRect: aRect];	

}

- (BOOL)shouldDrawInsertionPoint;
{
	if ( ![[vAOPrefs sharedPrefs] boolForKey: @"enabled"] )
		return [super shouldDrawInsertionPoint];

	if ( [[vAOPrefs sharedPrefs] boolForKey: @"noInsertionPointModificationInInsertMode"] && ![[self sharedData] commandMode] )
		return [super shouldDrawInsertionPoint];
		
	return YES;
}

- (NSColor *) insertionPointColor 
{
	
	NSColor * thisColor;
	
	// pick the color
	if ([[self window] firstResponder] != self) 
	{ 
		// inactive
		thisColor = [vAOPrefs getColorWithName:@"inactive"]; 
		//thisColor = [NSColor blackColor]; 
	} 
	else if ( [[self sharedData] visualMode] )
	{
		// visual mode
		thisColor = [vAOPrefs getColorWithName:@"visual"];
	}
	else if ( [[self sharedData] commandMode] )
	{
		// command mode
		thisColor = [vAOPrefs getColorWithName:@"command"];
	}
	else
	{
		// insert mode
		thisColor = [vAOPrefs getColorWithName:@"insert"];
	}
	
	return thisColor;
}

// change the color of the selection based on our state
- (NSDictionary *)selectedTextAttributes;
{
	if ( ![[vAOPrefs sharedPrefs] boolForKey: @"enabled"] )
		return [super selectedTextAttributes];

	if ( [[vAOPrefs sharedPrefs] boolForKey: @"noInsertionPointModificationInInsertMode"] && ![[self sharedData] commandMode] )
		return [super selectedTextAttributes];
		
	NSDictionary *atts = [super selectedTextAttributes];	
//NSLog(@"getting selectedTextAttributes %@", atts);

//NSLog(@"background: %@, alpha: %@", [atts objectForKey:NSBackgroundColorAttributeName], [[atts objectForKey:NSBackgroundColorAttributeName] alphaComponent]);
//NSLog(@"foreground: %@", [atts objectForKey:NSForegroundColorAttributeName]);

	// makes it very pretty, we'll make it a little darker too
	NSColor *newBack = [[self backgroundColor] blendedColorWithFraction: [[vAOPrefs sharedPrefs] floatForKey: @"selectionAlpha"] 
		ofColor:[self insertionPointColor]];
	
	NSDictionary *newAtts = [NSDictionary dictionaryWithObjectsAndKeys: 
		newBack, NSBackgroundColorAttributeName, 
		[atts objectForKey:NSForegroundColorAttributeName], NSForegroundColorAttributeName, 
		nil];

//NSLog(@"setting selectedTextAttributes %@", newAtts);
	
	// we can draw the insertion point here, we just need to figure out which end to put it on
	//NSRect caretRect = [self getInsertionPointRect];
	//[self drawInsertionPointInRect: caretRect color: [self insertionPointColor] turnedOn: TRUE];
		
	return newAtts;
}


/*
 rectForCharacterIndex: method from:
    http://www.cocoabuilder.com/archive/message/cocoa/2005/3/31/131832
    SUBJECT: Re: boundingRectForGlyphRange oddness - what on earth?
    FROM: Keith Blount
    DATE: Thu Mar 31 01:30:08 2005
*/

- (NSRect)rectForCharacterIndex:(int)charIndex
{
	NSLayoutManager *layoutManager = [self layoutManager];
	NSTextContainer *textContainer = [self textContainer];
	unsigned rectCount;
	
	if  ( charIndex < 0 ) 
		return NSZeroRect; 
	
	NSRectArray rectArray = [layoutManager rectArrayForCharacterRange:NSMakeRange(charIndex,1)
		withinSelectedCharacterRange:NSMakeRange(NSNotFound,0) inTextContainer:textContainer rectCount:&rectCount];
	
	if (rectCount)
		return rectArray[0];
	
	return NSZeroRect;
}


#pragma mark	-
#pragma mark	Pasteboard Injection

// write some extra data to the pasteboard for pasting lines
- (BOOL)writeSelectionToPasteboard:(NSPasteboard *)pboard type:(NSString *)type
{
	if ( [type isEqualToString: viAllOverPasteboardType] )
	{
		NSPasteboard *pb = [NSPasteboard generalPasteboard];
		
		// add our type
		if ( [self selectionGranularity] == NSSelectByParagraph )
		{
//NSLog(@"time to add our type");
			[pb setString:@"YES" forType:viAllOverPasteboardType];
		}
		else
		{
			[pb setString:@"NO" forType:viAllOverPasteboardType];
		}
	}
	
	return [super writeSelectionToPasteboard:pboard type:type];
}

- (BOOL)writeSelectionToPasteboard:(NSPasteboard *)pboard types:(NSArray *)types
{
	// inject our type into the list of pasteboard types
	NSMutableArray *newTypes = [NSMutableArray arrayWithObject: viAllOverPasteboardType];
	[newTypes addObjectsFromArray: types];
	
	return [super writeSelectionToPasteboard:pboard types:newTypes];
}


#pragma mark	-
#pragma mark	Selection Stuff

- (NSRange)get_new_lookHere_location_forSelectionModification: (BOOL)modify;
{
	return [self get_new_lookHere_location_forSelectionModification:modify backward:false];
}

- (NSRange)get_new_lookHere_location_forSelectionModification: (BOOL)modify backward: (BOOL)backward;
{
	unsigned int strLength = [[self string] length];

	NSRange lookHere = [self selectedRange];
	
	// if there is already a selection and we are modifying start looking after the selection
	/*
	if ( modify ) //&& lookHere.length > 0 ) 
	{
		NSSelectionAffinity affin = [self selectionAffinity];
		
		if ( affin == NSSelectionAffinityDownstream ) // towards bottom
		{
				NSLog(@"downstream");
			lookHere.location = lookHere.location + lookHere.length;
		}
		else if ( affin == NSSelectionAffinityUpstream ) // towards top
		{
			//lookHere.location = lookHere.location + lookHere.length;
				NSLog(@"upstream");
		}
	}
	*/
	
	if ( !backward )
	{
		// check everything from the cursor to the end
		lookHere.length = strLength - lookHere.location; 
	}
	else
	{
if (DEBUG) NSLog(@"looking backward");
		lookHere.length = lookHere.location;
		lookHere.location = 0;
	}
	
	return lookHere;
}


- (void)select_new_Range: (NSRange)nextSpot forSelectionModification: (BOOL)modify;
{
		if ( !modify )
			nextSpot.length = 0;
		else
		{
			
			NSSelectionAffinity affin = [self selectionAffinity];
			
			if ( affin == NSSelectionAffinityDownstream ) // towards bottom
			{
				if (DEBUG) NSLog(@"downstream"); // nothing to do
			}
			else if ( affin == NSSelectionAffinityUpstream ) // towards top
			{
				if (DEBUG) NSLog(@"upstream"); // nothing to do
			}
// bummer, it's not the mark
//NSLog(@"modifing selection: %@", NSStringFromRange([self markedRange]));

			nextSpot = NSUnionRange([self selectedRange], nextSpot);
		}
		
		//if ( [[[self sharedData] visualMode] isEqualToString:@"V"] )
		//	nextSpot = [self selectionRangeForProposedRange:nextSpot granularity:NSSelectByParagraph];
		
		[self setSelectedRange: nextSpot affinity: NSSelectionAffinityDownstream stillSelecting: NO ];
}

/*
- (void)setSelectedRanges:(NSRange)charRange affinity:(NSSelectionAffinity)affinity stillSelecting:(BOOL)flag
{
}
*/

/*
- (void)setSelectedRange:(NSRange)aRange
{
//NSLog(@"Setting selected range: %@", NSStringFromRange( aRange ));
	[super setSelectedRange: aRange];
}
*/

- (void)setSelectedRange:(NSRange)charRange affinity:(NSSelectionAffinity)affinity stillSelecting:(BOOL)flag
{
	// the mouse made a selection switch to visual mode
	if ( flag && [[self sharedData] commandMode] && charRange.length > 0 ) 
	{
		if ( [self selectionGranularity] == NSSelectByParagraph )
			[[self sharedData] setVisualMode: @"V"]; 
		else
			[[self sharedData] setVisualMode: @"v"]; 
	}
	else if ( flag && [[self sharedData] commandMode] )
	{
		[[self sharedData] setVisualMode: FALSE];
	}
		
	//if ( affinity == NSSelectionAffinityDownstream ) // towards bottom
	//{
		//NSLog(@"setting the selection affinity to downstream"); // nothing to do
	//}
	//else if ( affinity == NSSelectionAffinityUpstream ) // towards top
	//{
		//NSLog(@"setting the selection affinity to upstream"); // nothing to do
	//}

//NSLog(@"range: %@ stillSelecting: %d", NSStringFromRange(charRange), flag);
//NSLog(@"typing atts: %@", [self typingAttributes]);
//NSLog(@"mark: %@", NSStringFromRange([self markedRange]));

	// makes visual line mode work a little better
	if ( [[[self sharedData] visualMode] isEqualToString: @"V"] )
		charRange = [self selectionRangeForProposedRange:charRange granularity:NSSelectByParagraph];

	[super setSelectedRange:charRange affinity:affinity stillSelecting:flag];

	if ( [[[self sharedData] visualMode] isEqualToString: @"V"] )
		[self setSelectionGranularity:NSSelectByParagraph];
}

/*
- (NSRange)selectionRangeForProposedRange:(NSRange)proposedSelRange granularity:(NSSelectionGranularity)granularity
{
NSLog(@"selection modification");
	[super selectionRangeForProposedRange: proposedSelRange granularity: granularity];
}
*/

#pragma mark	-
#pragma mark	Instance Data Stuff

static NSMapTable *_instanceMap = nil;

+ (NSMapTable *) _instanceMap;
{
	if( nil == _instanceMap )
	{
		_instanceMap = NSCreateMapTable( NSNonRetainedObjectMapKeyCallBacks, NSObjectMapValueCallBacks, 4 );
	}
	
	return _instanceMap;
}

// field specific
- (id)sharedData;
{
	vAOData *sharedInstance = NSMapGet( [[self class] _instanceMap], self);

    if (!sharedInstance) 
	{
        sharedInstance = [[vAOData alloc] init];
		NSMapInsert( [[self class] _instanceMap], self, sharedInstance);
//NSLog(@"self: %@, instance: %@", self, sharedInstance);
    }
	
    return sharedInstance;
}


// app specific 
+ (id)sharedData;
{
	vAOData *sharedInstance = NSMapGet( [[self class] _instanceMap], self);

    if (!sharedInstance) 
	{
        sharedInstance = [[vAOData alloc] init];
		NSMapInsert( [[self class] _instanceMap], self, sharedInstance);
//NSLog(@"self: %@, instance: %@", self, sharedInstance);
    }
	
    return sharedInstance;
}

- (void)dealloc 
{
	// clean up after ourselves
	NSMapRemove([[self class] _instanceMap], self);
	
	[super dealloc];
}



@end









