//
//  vAOScrollView.m
//  viAllOver
//
//  Copyright (c) 2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 


#import "vAOScrollView.h"
#import "vAOPrefs.h"
#import "vAOConstants.h"

@implementation vAOScrollView

- (void)keyDown:(NSEvent *)theEvent
{
	if ( ![[vAOPrefs sharedPrefs] boolForKey: @"enabled"] || ![[vAOPrefs sharedPrefs] boolForKey: @"useMovementKeysInScrollViews"] )
		return [super keyDown: theEvent];

	// we get events for key presses
	// looks like we are going to have to check to see if we should
	// handle them or pass them on
	
	BOOL modifiers = FALSE;

    if ( ([theEvent modifierFlags] & NSShiftKeyMask) ||
		 ([theEvent modifierFlags] & NSControlKeyMask) ||
		 ([theEvent modifierFlags] & NSAlternateKeyMask) ||
		 ([theEvent modifierFlags] & NSCommandKeyMask) ) 
	{
		modifiers = TRUE;
	}

	NSMutableString *checkChar = [NSMutableString string];
	
	if ( [theEvent modifierFlags] & NSControlKeyMask )
	{
		if ( [theEvent modifierFlags] & NSControlKeyMask ) 
			[checkChar appendString: controlKey];
		
		[checkChar appendString: [theEvent charactersIgnoringModifiers]];
	}
	else
	{
		[checkChar appendString: [theEvent characters]];
	}
		
//NSLog(@"keydown: '%@'", checkChar);

	NSString *ss = nil;

	if ( [checkChar length] > 0 )
	{
		NSDictionary *bindings = nil;
		
		// check user defaults
		bindings = [[[vAOPrefs sharedPrefs] valueForKey: bindingsKey] valueForKey: bindingsScrollingKey];
		if ( bindings != nil )
		{
			ss = [bindings objectForKey: checkChar];
		}
		
		// check the app defaults
		if ( ss == nil )
		{
			bindings = [[[vAOPrefs defaults] valueForKey: bindingsKey] valueForKey: bindingsScrollingKey];
			if ( bindings != nil )
			{
				ss = [bindings objectForKey: checkChar];
			}
		}
	}
	
	if ( ss != nil && ( [ss isKindOfClass: [NSString class]] && [ss length] > 0 ) )
	{
		// check for key commands
		if ( [ss hasPrefix: commandKey] || [ss hasPrefix: optionKey] || [ss hasPrefix: controlKey] || [ss hasPrefix: shiftKey] ) 
		{
			[self sendKeyCommandFromString: ss];
		}
		else
		{
//NSLog(@"ss: %@", ss);
			id t = [NSApp targetForAction: NSSelectorFromString(ss)];
//NSLog(@"t: %@", t);
			if ( t != nil )
				[t doCommandBySelector: NSSelectorFromString(ss)];
		}
	}
	else
	{
		// don't know what to do, better let someone else take care of it.
		[super keyDown: theEvent];
	}
}

- (void)sendKeyCommandFromString:(NSString *)command;
 {
	int i;
	NSString *character;
	unsigned int modifiers = 0;
	BOOL escaped = NO, escape = NO;
	
	// check for command keys until there are no more
	int cmdLength = [command length];
	for ( i = 0; i < cmdLength; i++ )
	{
		character = [command substringWithRange: NSMakeRange(i, 1)];
		
		if ( !escaped ) 
		{
			if ( [character isEqualToString: @"/"] ) 
			{
				if ( escape )
				{
					escaped = YES;
					escape = NO;
				}
				else
					escape = YES;
			}
			else if ( [character isEqualToString: commandKey] ) 
				modifiers |= NSCommandKeyMask;
			else if ( [character isEqualToString: optionKey] ) 
				modifiers |= NSAlternateKeyMask;
			else if ( [character isEqualToString: controlKey] ) 
				modifiers |= NSControlKeyMask;
			else if ( [character isEqualToString: shiftKey] ) 
				modifiers |= NSShiftKeyMask;
		}
		
	}

//NSLog(@"sending char: %@", character);
	
	// make the event
	NSEvent * e = [NSEvent keyEventWithType: NSKeyDown 
		location: NSMakePoint(0,0) 
		modifierFlags: modifiers 
		timestamp: 0 //[NSDate timeIntervalSinceReferenceDate]
		windowNumber: 0 //[self window]
		context: [NSGraphicsContext currentContext] //[NSGraphicsContext graphicsContextWithWindow: [self window]]
		characters: character
		charactersIgnoringModifiers: [character lowercaseString]
		isARepeat: NO
		keyCode: nil];
	
	// make sure it's good and send it
	if  (e != nil)
		[NSApp sendEvent: e];

}
#pragma mark	-
#pragma mark	Scrolling Support

- (void)vAO_scrollPageDown:(id)sender
{
	// get the current scroll position of the document view
	NSPoint currentScrollPosition=[[self contentView] bounds].origin;
	
//NSLog(@"start here: %@, this tall: %@, this much left %f", NSStringFromPoint(currentScrollPosition), [self verticalPageScroll]);
	
	currentScrollPosition.y += [[self contentView] bounds].size.height - [self verticalPageScroll];
	
//NSLog(@"move to here: %@", NSStringFromPoint(currentScrollPosition));
	// move to the new scroll location
	[[self documentView] scrollPoint:currentScrollPosition];
}

- (void)vAO_scrollHalfPageDown:(id)sender
{
	// get the current scroll position of the document view
	NSPoint currentScrollPosition=[[self contentView] bounds].origin;
		
	currentScrollPosition.y += [[self contentView] bounds].size.height / 2 - [self verticalPageScroll];
	
	// move to the new scroll location
	[[self documentView] scrollPoint:currentScrollPosition];
}

- (void)vAO_scrollPageUp:(id)sender
{
	// get the current scroll position of the document view
	NSPoint currentScrollPosition=[[self contentView] bounds].origin;
		
	currentScrollPosition.y -= [[self contentView] bounds].size.height - [self verticalPageScroll];
	
	// move to the new scroll location
	[[self documentView] scrollPoint:currentScrollPosition];
}

- (void)vAO_scrollHalfPageUp:(id)sender
{
	// get the current scroll position of the document view
	NSPoint currentScrollPosition=[[self contentView] bounds].origin;
		
	currentScrollPosition.y -= [[self contentView] bounds].size.height / 2 - [self verticalPageScroll];
	
	// move to the new scroll location
	[[self documentView] scrollPoint:currentScrollPosition];
}

- (void)vAO_scrollLineDown:(id)sender
{
	// get the current scroll position of the document view
	NSPoint currentScrollPosition=[[self contentView] bounds].origin;
	
	currentScrollPosition.y += [self verticalLineScroll];
	
	// move to the new scroll location
	[[self documentView] scrollPoint:currentScrollPosition];
}

- (void)vAO_scrollLineUp:(id)sender
{
	// get the current scroll position of the document view
	NSPoint currentScrollPosition=[[self contentView] bounds].origin;
	
	currentScrollPosition.y -= [self verticalLineScroll];
	
	// move to the new scroll location
	[[self documentView] scrollPoint:currentScrollPosition];
}

- (void)vAO_scrollLineLeft:(id)sender
{
	// get the current scroll position of the document view
	NSPoint currentScrollPosition=[[self contentView] bounds].origin;
	
	currentScrollPosition.x -= [self horizontalLineScroll];
	
	// move to the new scroll location
	[[self documentView] scrollPoint:currentScrollPosition];
}

- (void)vAO_scrollLineRight:(id)sender
{
	// get the current scroll position of the document view
	NSPoint currentScrollPosition=[[self contentView] bounds].origin;
	
	currentScrollPosition.x += [self horizontalLineScroll];
	
	// move to the new scroll location
	[[self documentView] scrollPoint:currentScrollPosition];
}

@end
