//
//  vAOPrefs.m
//  viAllOver
//
//  Copyright (c) 2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 

#import "vAOPrefs.h"
#import "vAOConstants.h"


@implementation vAOPrefs

- (id)init
{
	self = [super init];
	
	if  ( self )
	{
		// register for changes to prefs
		NSDistributedNotificationCenter *center = [NSDistributedNotificationCenter defaultCenter]; 
		[center addObserver: self 
			selector: @selector(syncPrefs:) 
			name: prefChangeNotification
			object: prefChangeNotification];
	}
	
	return self;
}

- (id)valueForKey:(id)aKey
{
//NSLog(@"getting value for key: %@", aKey);

	return [super valueForKey: aKey];
}

- (BOOL)boolForKey:(NSString *)defaultName;
{
	BOOL ret = [[super valueForKey: defaultName] boolValue];
//NSLog(@"bool for key %@", defaultName);
	return ret;
}

- (float)floatForKey:(NSString *)defaultName;
{
	float ret = [[super valueForKey: defaultName] floatValue];
//NSLog(@"bool for key %@", defaultName);
	return ret;
}

- (void)setValue:(id <NSCoding>)value forKey:(NSString *)key
{
//NSLog(@"set value %@->%@", key, value);
//NSLog(@"set key %@", key);
	[super setValue: value forKey: key];
}


- (vAOPrefs *) sharedPrefs;
{
	return [[self class] sharedPrefs];
}

+ (vAOPrefs *) sharedPrefs;
{
	static vAOPrefs *_sharedPrefs = nil;
	
	if ( nil == _sharedPrefs )
	{
		_sharedPrefs = [[vAOPrefs alloc] init];
	}
	
	return _sharedPrefs;
}

#pragma mark	-
#pragma mark	read defaults

+ (NSDictionary *)defaults; 
{
    if ( nil == defaults )
    {
		// load from bundle
		NSBundle * b = [NSBundle bundleForClass: [self class]];
		//NSString *bId = [b bundleIdentifier];

//NSLog(@"getting defaults for: %@/%@", b, bId);
		
		// should probably try a bit harder to find the defaults that we are actually using
		// rather than a copy from the bundle we are in
		defaults = [[NSDictionary dictionaryWithContentsOfFile: 
			[b pathForResource:@"defaults" ofType:@"plist"]] retain];
		// don't release it, its static
		
		//NSLog(@"trying to load movement keys dict: %@", [b pathForResource:@"movementKeys" ofType:@"plist"]);
		
		if ( defaults ) {
			//NSLog(@"loaded default dict");
		} else {
			NSLog(@"failed loading default dict");
		}
		
    }
	
	return (NSDictionary *) defaults;
}

+ (NSColor *) getColorWithName: (NSString *)colorName;
{
	NSDictionary *colorDict = nil;
	
	colorDict = [[vAOPrefs sharedPrefs] valueForKey: [colorName stringByAppendingString:@"Color"]];
	
	NSColor *thisColor = [NSColor colorWithCalibratedRed:[[colorDict objectForKey:@"red"] floatValue]
		green:[[colorDict objectForKey:@"green"] floatValue]
		blue:[[colorDict objectForKey:@"blue"] floatValue]
		alpha:1.0];

	return thisColor;
}


#pragma mark	-
#pragma mark	key value observing
/*
- (void)addObserver:(NSObject *)anObserver forKeyPath:(NSString *)keyPath options:(NSKeyValueObservingOptions)options context:(void *)context
{
NSLog(@"%@: add observer: %@ for key path: %@", self, anObserver, keyPath);
	[super addObserver: anObserver forKeyPath: keyPath options: options context: context];
}

- (void)removeObserver:(NSObject *)anObserver forKeyPath:(NSString *)keyPath
{
NSLog(@"%@: remove observer: %@ for key path: %@", self, anObserver, keyPath);
	if ( [keyPath rangeOfString: @"."].location == NSNotFound )
		[super removeObserver: anObserver forKeyPath: keyPath];
}
*/
/*
+ (BOOL)automaticallyNotifiesObserversForKey:(NSString *)theKey 
{
	return [super automaticallyNotifiesObserversForKey: theKey];
	
	BOOL automatic = NO;
 
    if ( [theKey isEqualToString:@"exclude"] ) 
	{
        automatic = NO;
    } 
	else 
	{
        automatic = [super automaticallyNotifiesObserversForKey: theKey];
    }
	
    return automatic;
}
*/

#pragma mark	-
#pragma mark	key value coding


- (id)valueForUndefinedKey:(NSString *)key
{
//NSLog(@"%@: undefined key: %@", self, key);
	//NSArray *keys = [self splitKeys: key];
	//[self valueForUndefinedKeyArray: keys];
	
	NSArray *nilValues = [NSArray arrayWithObjects: @"excludedApps", @"bindings", nil];
	
	NSString *bundleId = [[NSBundle bundleForClass: [self class]] bundleIdentifier];

	id obj = (id)CFPreferencesCopyValue((CFStringRef)key, (CFStringRef)bundleId, kCFPreferencesCurrentUser, kCFPreferencesAnyHost);
	
	if ( nil == obj && ![nilValues containsObject: key] )
	{
		// get the value from the defaults
		obj = [[vAOPrefs defaults] valueForKey: key];
	}
	
//NSLog(@"found obj: %@", obj);
	
	return obj;

}


- (void)setValue:(id)value forUndefinedKey:(NSString *)key
{
	// only write to user defauts
NSLog(@"setting value: %@ for undefined key: %@", value, key);

	NSString *bundleId = [[NSBundle bundleForClass: [self class]] bundleIdentifier];

	CFPreferencesSetValue((CFStringRef)key, (CFPropertyListRef)value, (CFStringRef)bundleId, kCFPreferencesCurrentUser, kCFPreferencesAnyHost);
	
	// update the preference file all the time
	[self synchronize];
	[self notifyEveryoneThatThePrefsChanged];
}

- (NSArray *)splitKeys: (NSString *)toSplit;
{
	NSArray *keys = [toSplit componentsSeparatedByString: @"__"];
//NSLog(@"the keys: %@", keys);

	return keys;
}


#pragma mark	-
#pragma mark	defaults sync

- (void)syncPrefs:(NSNotification *)myNotification; 
{
	[self synchronize];
}

- (BOOL)synchronize
{
//NSLog(@"syncing prefs");
	NSString *bundleId = [[NSBundle bundleForClass: [self class]] bundleIdentifier];

	CFPreferencesSynchronize((CFStringRef)bundleId,
                kCFPreferencesCurrentUser,
                kCFPreferencesAnyHost);
}

- (void)notifyEveryoneThatThePrefsChanged;
{
	// notify everyone that the prefs changed
	//NSString *observedObject = @"com.apple.example.PrefpaneTarget"; 
	NSDistributedNotificationCenter *center = [NSDistributedNotificationCenter defaultCenter]; 
	
	[center postNotificationName: prefChangeNotification
		object: prefChangeNotification 
		userInfo: nil /* no dictionary */ 
		deliverImmediately: YES]; 

}

@end
