//
//  vAOExcludeArrayController.m
//  viAllOver
//
//  Copyright (c) 2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 


#import "vAOExcludeArrayController.h"
#import "vAOPrefs.h"
#import "vAOConstants.h"


@implementation vAOExcludeArrayController

+ (void)initialize 
{

	[super initialize];
	
    [self setKeys:
        [NSArray arrayWithObjects:@"canRemove", nil]
        triggerChangeNotificationsForDependentKey:@"selectionIndex"];

}

- (id)initWithContent:(id)content
{
	self = [super initWithContent: content];
	
	if ( nil != self )
	{
		[removeButton setEnabled: NO];

	}
	
	return self;
}

- (int)numberOfRowsInTableView:(NSTableView *)tableView
{
    //return [[vAOPrefs defaults] count] + [[vAOPrefs userDefaults] count];
	int aryCount = [[[vAOPrefs sharedPrefs] valueForKey: excludedAppsKey] count];
	int ary2Count = [[[vAOPrefs defaults] valueForKey: excludedAppsKey] count];
//NSLog(@"counting exclude list: %d", aryCount);
    return aryCount + ary2Count;
}

- (id)tableView:(NSTableView *)tableView objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)row
{
	int defaultsCount = [[[vAOPrefs defaults] valueForKey: excludedAppsKey] count];
//NSLog(@"getting value for row: %d, defaultsCount: %d", row, defaultsCount);
	NSDictionary *exclude;
	
	if ( row >= defaultsCount )
		exclude = [[[vAOPrefs sharedPrefs] valueForKey: excludedAppsKey] objectAtIndex: row - defaultsCount];
	else
		exclude = [[[vAOPrefs defaults] valueForKey: excludedAppsKey] objectAtIndex: row];
		
	NSString *name = [exclude valueForKey: @"name"];
	
	if ( nil == name || [name length] < 1 )
	{
		name = [exclude valueForKey: @"id"];
	}
	
	return name;
}

- (void)tableView:(NSTableView *)aTableView setObjectValue:(id)anObject forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
//NSLog(@"setting value for row: %d", rowIndex);
}

- (void)tableViewSelectionDidChange:(NSNotification *)aNotification
{
//NSLog(@"selection changed!");
	selectionIndex = [[aNotification object] selectedRow];
	
//NSLog(@"selected index: %d", [self selectionIndex]);
//NSLog(@"notification: %@", aNotification);

	//[self setCanRemove: YES];
	[removeButton setEnabled: [self canRemove]];
}

- (BOOL)canRemove
{
	int index = [self selectionIndex];
	int defaultsCount = [[[vAOPrefs defaults] valueForKey: excludedAppsKey] count];

	if ( index == NSNotFound || index < 0 || index < defaultsCount )
		return NO;
	else
	{
//NSLog(@"can remove selected index: %d", index);
		return YES;
	}
}

- (BOOL)setSelectionIndex:(unsigned int)index
{
//NSLog(@"set selection index: %d", index);

	if ( index < 0 )
		selectionIndex = NSNotFound;
	else
		selectionIndex = index;

	int defaultsCount = [[[vAOPrefs defaults] valueForKey: excludedAppsKey] count];

	[ourTableView selectRowIndexes: [NSIndexSet indexSetWithIndex: selectionIndex + defaultsCount] byExtendingSelection: NO];
	[ourTableView noteNumberOfRowsChanged];
	
	return YES;
}

- (unsigned int)selectionIndex;
{
	return selectionIndex;
}

- (id)newObject
{
    newObject = [super newObject];
	
	NSOpenPanel * panel = [NSOpenPanel openPanel];

	[panel setAllowedFileTypes: [NSArray arrayWithObject:@"app"]];
	[panel setAllowsMultipleSelection: NO];
	[panel runModal];
	
	NSString *appPath = [[panel filenames] objectAtIndex:0];
	
	NSBundle *appBundle = [NSBundle bundleWithPath:appPath];
	
	NSString *appIdentifier = [appBundle bundleIdentifier];

//NSLog(@"bundle info: %@", [appBundle infoDictionary]);
	NSArray *appPathParts = [appPath pathComponents];
	
	NSString *appName = [[appPathParts objectAtIndex: [appPathParts count] - 1] stringByDeletingPathExtension];

	//NSLog(@"%@ - %@", appName, appIdentifier);

    [newObject setValue: appName forKey:@"name"];
    [newObject setValue: appIdentifier forKey:@"id"];

	NSMutableArray *xList = [[vAOPrefs sharedPrefs] valueForKey: excludedAppsKey];
	
	int selectedRow = 0;
	

	// don't add twice
	if ( [xList containsObject: newObject] )
	{
		[self setSelectionIndex: [xList indexOfObject: newObject]];
		return nil;
	}
	else
	{
		// probably not the right place
		//[xList addObject: newObject];
	}
	
//NSLog(@"newObject, %@: %@", [newObject class], newObject);
    return newObject;
}

- (void)add:(id)sender;
{
if ( DEBUG ) NSLog(@"add object");
	// get the users list
	NSMutableArray *xList = [[[vAOPrefs sharedPrefs] valueForKey: excludedAppsKey] mutableCopy];

	if ( nil == xList )
		xList = [NSMutableArray array];
		
	// add the new object
	id theNewObject = [self newObject];
	if ( nil != theNewObject )
	{
//NSLog(@"adding: %@ to %@", theNewObject, [xList class]);
		[self willChangeValueForKey: excludedAppsKey];
		[xList addObject: theNewObject];
		
		// save the new list
		[[vAOPrefs sharedPrefs] setValue: xList forKey: excludedAppsKey];
		[self didChangeValueForKey: excludedAppsKey];
		
		[ourTableView noteNumberOfRowsChanged];
		[ourTableView reloadData];
		[self setSelectionIndex: [xList indexOfObject: theNewObject]];
	}
}

- (void)remove:(id)sender
{
	if ( [self canRemove] )
	{
//NSLog(@"sender: %@", sender);
		int defaultsCount = [[[vAOPrefs defaults] valueForKey: excludedAppsKey] count];

		NSMutableArray *xList = [[[vAOPrefs sharedPrefs] valueForKey: excludedAppsKey] mutableCopy];

		[xList removeObjectAtIndex: [self selectionIndex] - defaultsCount];
		
		[[vAOPrefs sharedPrefs] setValue: xList forKey: excludedAppsKey];
		
		[ourTableView noteNumberOfRowsChanged];
	}
}

/*
- (void)addObserver:(NSObject *)anObserver forKeyPath:(NSString *)keyPath options:(NSKeyValueObservingOptions)options context:(void *)context
{
NSLog(@"%@: add observer: %@ for key path: %@", self, anObserver, keyPath);
	[super addObserver: anObserver forKeyPath: keyPath options: options context: context];
}
*/

#pragma mark	-
#pragma mark	tableview delagates

- (BOOL)tableView:(NSTableView *)aTableView shouldEditTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	//if ( [aTableView isEqualTo: excludeTableView] )
	{
			return NO;
	}
	
	return YES;
}

- (void)tableView:(NSTableView *)aTableView willDisplayCell:(id)aCell forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	int defaultsCount = [[[vAOPrefs defaults] valueForKey: excludedAppsKey] count];
	if ( rowIndex < defaultsCount )
	{
		// gray it out
//NSLog(@"aCell: %@", [aCell textColor]);
		[aCell setTextColor: [NSColor grayColor]];
	}
	else
	{
		// normal
		[aCell setTextColor: [NSColor textColor]];
	}
	
}

- (BOOL)tableView:(NSTableView *)aTableView shouldSelectRow:(int)rowIndex
{
	int defaultsCount = [[[vAOPrefs defaults] valueForKey: excludedAppsKey] count];
	if ( rowIndex < defaultsCount )
	{
		// gray it out
		return NO;
	}
	else
	{
		// normal
		return YES;
	}
	

}

@end
