//
//  vAOData.m
//  viAllOver
//
//  Copyright (c) 2004-2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 


#import "vAOData.h"


@implementation vAOData

static vAOData *sharedInstance = nil;
static NSMutableDictionary *defaultCommands = nil, *userCommands = nil;

+ (id)sharedData {
	
	//static vAOData *sharedInstance = nil;
	
    if (!sharedInstance) {
        sharedInstance = [[vAOData alloc] init];
    }
	
    return sharedInstance;
}

- (BOOL) commandMode {
	return commandMode;
}

- (void) setCommandMode: (BOOL) val {
	commandMode = val;
}

- (NSString *) specialMode {
	return specialMode;
}

- (void) setSpecialMode: (NSString *) val 
{
	[specialMode autorelease];
	specialMode = [val retain];
}

- (BOOL) isSpecialMode: (NSString *) val;
{
	return [[[vAOData sharedData] specialMode] isEqualToString: val];
}

- (NSString *) visualMode {
	return visualMode;
}

- (void) setVisualMode: (NSString *) val {
	[visualMode release];
	visualMode = [val retain];
}

- (BOOL) repeatingLastEdit;
{
	return repeatingLastEdit;
}

- (void) setRepeatingLastEdit: (BOOL) val;
{
	repeatingLastEdit = val;
}

- (BOOL) recordCommand;
{
	return recordCommand;
}

- (void) setRecordCommand: (BOOL) val;
{
NSLog(@"setting recordCommand to %d", val);
	recordCommand = val;
}

- (void) addToRecordedCommand: (NSString *) aString;
{
	if ( !recordedCommand )
		[self resetRecordedCommand];

	// don't add repeat '.' to the list
	if ( [aString isEqualToString: @"."] )
		return;
		
NSLog(@"adding '%@' to '%@'", aString, recordedCommand);
	
	NSString *oldRecordedCommand = [recordedCommand copy];
	[recordedCommand release];
	recordedCommand = nil;
	
	recordedCommand = [[oldRecordedCommand stringByAppendingString: aString] retain];
}

- (NSString *) popFromRecordedCommand;
{
	if ( !recordedCommand )
	{
		[self resetRecordedCommand];
		return FALSE;
	}
	
//NSLog(@"adding '%@' to '%@'", aString, recordedCommand);
	
	NSString *oldRecordedCommand = [recordedCommand copy];
	[recordedCommand release];
	recordedCommand = nil;
	
	recordedCommand = [[oldRecordedCommand substringToIndex: [oldRecordedCommand length] - 1] retain];
NSLog(@"poped, %@", recordedCommand);
	
	return [oldRecordedCommand substringFromIndex: [oldRecordedCommand length] - 1];
}

- (void) resetRecordedCommand;
{
	if ( recordedCommand )
		[recordedCommand release];

	recordedCommand = [@"" retain];
}

- (NSString *) recordedCommand;
{
	return recordedCommand;
}

- (BOOL) insertionPointLock {
	return insertionPointLock;
}

- (void) setInsertionPointLock: (BOOL) val {
	insertionPointLock = val;
}

- (void) setRepeatTimes: (int) times; {
	repeatTimes = times;
}

- (int) repeatTimes {
	return repeatTimes;
}

- (NSString *) replaceChar; {
	return replaceChar;
}

- (void) setReplaceChar: (NSString *) val; {
	[replaceChar release];
	replaceChar = [val retain];
}

- (void) setCommand: (vAOCommand *) cmd {
	if ( command ) {
		[command release];
	}
	command = [cmd retain];
}

- (vAOCommand *) command {
	return command;
}

- (NSRect)oldDotRect {
	return oldDotRect;
}

- (void)setOldDotRect: (NSRect)rect {
	oldDotRect = rect;
}
- (NSRect) oldInsertionPointRect;{
	return oldInsertionPointRect;
}

- (void) setOldInsertionPointRect: (NSRect) rect;{
	oldInsertionPointRect = rect;
}

- (NSRange) mark;
{
	return mark;
}

- (void) setMark: (NSRange) range;
{
	mark = range;
}


- (NSDate *) lastUpdate {
	// we need to set a default
	if ( !lastUpdate ) {
		[self setLastUpdate: [NSDate distantPast]];
	}
	
	return lastUpdate;
}

- (void) setLastUpdate: (NSDate *) when {
	[lastUpdate autorelease];
	lastUpdate = [when retain];
}


+ (NSColor *) getColorWithName: (NSString *)colorName;
{
	NSDictionary *colorDict = nil;
	
	NSDictionary *userColors = [[vAOData getUserCommandDict] objectForKey:@"color"];
	
//NSLog(@"colorName: %@", colorName);
//NSLog(@"colorDict: %@", userColors);
	if ( userColors )
	{
		colorDict = [userColors objectForKey:colorName];
	}
	else
	{
		NSDictionary *defaulColors = [[vAOData getDefaultCommandDict] objectForKey:@"color"];
		
		colorDict = [defaulColors objectForKey:colorName];
	}

//NSLog(@"colorDict: %@", colorDict);
//NSLog(@"colors: %@", [[vAOData getDefaultCommandDict] objectForKey:@"color"]);
	
	NSColor *thisColor = [NSColor colorWithCalibratedRed:[[colorDict objectForKey:@"red"] floatValue]
		green:[[colorDict objectForKey:@"green"] floatValue]
		blue:[[colorDict objectForKey:@"blue"] floatValue]
		alpha:1.0];

	return thisColor;
}

+ (NSDictionary *)getDefaultCommandDict; 
{
    //static NSMutableDictionary *keyCommands = NULL;
	//NSDictionary *keyCommands1 = nil, *keyCommands2 = nil;
    
    if ( nil == defaultCommands )
    {
		// load movement key
		
		// load from bundle
		NSBundle * b = [NSBundle bundleForClass: [vAOData class]];
		
		defaultCommands = [[NSDictionary dictionaryWithContentsOfFile: 
			[b pathForResource:@"commands" ofType:@"plist"]] retain];
		// don't release it, its static
		
		//NSLog(@"trying to load movement keys dict: %@", [b pathForResource:@"movementKeys" ofType:@"plist"]);
		
		
		if ( defaultCommands ) {
			//NSLog(@"loaded default dict");
		} else {
			NSLog(@"failed loading default dict");
		}
		
    }
	
	return (NSDictionary *) defaultCommands;
}

+ (NSDictionary *)getUserCommandDict; 
{
    
	// check the mod time of the users command file
    NSFileManager *fm = [NSFileManager defaultManager];
	
	NSString *fullPath = [@"~/Library/Preferences/org.dabble.viAllOver.commands.plist" stringByExpandingTildeInPath];
	
    NSDictionary *thisAttr = [fm fileAttributesAtPath:fullPath traverseLink:YES];
	
    NSDate *thisModDate = [thisAttr objectForKey:NSFileModificationDate];
	
	//NSLog(@"checking: %@ with: %@", thisModDate, [[vAOData sharedData] lastUpdate]);
	
	if ( [thisModDate compare: [[vAOData sharedData] lastUpdate]] == NSOrderedDescending) {
		
		//NSLog(@"trying to load user's commands dict.");
		
		// now check and see if the user has anything to add
		userCommands = [[NSDictionary dictionaryWithContentsOfFile: fullPath] retain];
		
		if ( userCommands ) 
		{
			//NSLog(@"loaded user dict");
		} 
		else 
		{
			NSLog(@"failed loading user dict");
		}
		
		[[vAOData sharedData] setLastUpdate: [NSDate date]];
    }
	
	return (NSDictionary *) userCommands;
}

/*
+ (NSDictionary *)getCommandDict; {
    //static NSMutableDictionary *keyCommands = NULL;
	NSDictionary *keyCommands2 = NULL;
    
    if ( keyCommands == NULL )
    {
		// load movement key
		
		// load from bundle
		NSBundle * b = [NSBundle bundleForClass: [vAOData class]];
		
		keyCommands = [[NSDictionary dictionaryWithContentsOfFile: 
			[b pathForResource:@"commands" ofType:@"plist"]] retain];
		// don't release it, its static
		
		//NSLog(@"trying to load movement keys dict: %@", [b pathForResource:@"movementKeys" ofType:@"plist"]);
		
		
		if ( keyCommands )
			NSLog(@"loaded dict");
		else
			NSLog(@"failed loading dict");
		
    }
	
	// check the mod time of the users command file
    NSFileManager *fm = [NSFileManager defaultManager];
	
    NSDictionary *thisAttr = [fm fileAttributesAtPath:[@"~/Library/Preferences/org.viAllOver.commands.plist" stringByExpandingTildeInPath] traverseLink:YES];
	
    NSDate *thisModDate = [thisAttr objectForKey:NSFileModificationDate];
	
	//NSLog(@"checking: %@ with: %@", thisModDate, [[vAOData sharedData] lastUpdate]);
	
	if ( [thisModDate compare: [[vAOData sharedData] lastUpdate]] == NSOrderedDescending) {
		
		//NSLog(@"trying to load user's commands dict.");
		
		// now check and see if the user has anything to add
		keyCommands2 = [[NSDictionary dictionaryWithContentsOfFile: [@"~/Library/Preferences/org.viAllOver.commands.plist" stringByExpandingTildeInPath]] retain];
		
		if ( keyCommands2 ) {
			
			//NSLog(@"seems we have some user commands to load.");
			
			[keyCommands addEntriesFromDictionary: keyCommands2];
			
			[[vAOData sharedData] setLastUpdate: [NSDate date]];
			
			[keyCommands2 release];
		}
    }
	
	
    //return [keyCommands objectForKey: commandString];
	return (NSDictionary *) keyCommands;
}
*/
- (void)dealloc {
	// dealloc is called repeativaly then crashes if following uncommented
	//[keyCommands release];
	//[sharedInstance release];
	
	
	[super dealloc];
}

@end
