//
//  vAOData.m
//  viAllOver
//
//  Copyright (c) 2004-2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 


#import "vAOData.h"
#import "vAOTextView.h"
#import "vAOConstants.h"


@implementation vAOData


- (BOOL) commandMode 
{
//NSLog(@"commandMode: %d", commandMode);
	return commandMode;
}

- (void) setCommandMode: (BOOL) val 
{
//NSLog(@"set commandMode: %d", val);
	commandMode = val;
}

- (NSString *) specialMode 
{
	return specialMode;
}

- (void) setSpecialMode: (NSString *) val 
{
	[specialMode autorelease];
	specialMode = [val retain];
}

- (BOOL) isSpecialMode: (NSString *) val;
{
	if ( nil != [self specialMode] )
		return [[self specialMode] isEqualToString: val];
	else
		return FALSE;
}

- (NSString *) visualMode 
{
	return visualMode;
}

- (void) setVisualMode: (NSString *) val 
{
	[visualMode release];
	visualMode = [val retain];
}

- (BOOL) repeatingLastEdit;
{
	return repeatingLastEdit;
}

- (void) setRepeatingLastEdit: (BOOL) val;
{
	repeatingLastEdit = val;
}

- (BOOL) recordCommand;
{
	return recordCommand;
}

- (void) setRecordCommand: (BOOL) val;
{
if (DEBUG) NSLog(@"setting recordCommand to %d", val);
	recordCommand = val;
}

- (void) addToRecordedCommand: (NSString *) aString;
{
	if ( !recordedCommand )
		[self resetRecordedCommand];

	// don't add repeat '.' to the list
	if ( [aString isEqualToString: @"."] )
		return;
		
if (DEBUG) NSLog(@"adding '%@' to '%@'", aString, recordedCommand);
	
	NSString *oldRecordedCommand = [recordedCommand copy];
	[recordedCommand release];
	recordedCommand = nil;
	
	recordedCommand = [[oldRecordedCommand stringByAppendingString: aString] retain];
}

- (NSString *) popFromRecordedCommand;
{
	if ( !recordedCommand )
	{
		[self resetRecordedCommand];
		return FALSE;
	}
	
//NSLog(@"adding '%@' to '%@'", aString, recordedCommand);
	
	NSString *oldRecordedCommand = [recordedCommand copy];
	[recordedCommand release];
	recordedCommand = nil;
	
	recordedCommand = [[oldRecordedCommand substringToIndex: [oldRecordedCommand length] - 1] retain];
//NSLog(@"poped, %@", recordedCommand);
	
	return [oldRecordedCommand substringFromIndex: [oldRecordedCommand length] - 1];
}

- (void) resetRecordedCommand;
{
	if ( recordedCommand )
		[recordedCommand release];

	recordedCommand = [@"" retain];
}

- (NSString *) recordedCommand;
{
	return recordedCommand;
}

- (BOOL) insertionPointLock {
	return insertionPointLock;
}

- (void) setInsertionPointLock: (BOOL) val 
{
	insertionPointLock = val;
}

- (void) setRepeatTimes: (int) times; 
{
	repeatTimes = times;
}

- (int) repeatTimes {
	return repeatTimes;
}

- (NSString *) replaceChar; 
{
	return replaceChar;
}

- (void) setReplaceChar: (NSString *) val; 
{
	[replaceChar release];
	replaceChar = [val retain];
}

- (NSString *) lastLineFind;
{
	return lastLineFind;
}

- (void) setLastLineFind: (NSString *) val;
{
	[lastLineFind release];
	lastLineFind = [val retain];
}


- (void) setCommand: (vAOCommand *) cmd 
{
	if ( command ) 
	{
		[command release];
	}
	command = [cmd retain];
}

- (vAOCommand *) command 
{
	return command;
}

- (NSRect)oldDotRect 
{
	return oldDotRect;
}

- (void)setOldDotRect: (NSRect)rect 
{
	oldDotRect = rect;
}

- (NSRect) oldInsertionPointRect;
{
	return oldInsertionPointRect;
}

- (void) setOldInsertionPointRect: (NSRect) rect;
{
	oldInsertionPointRect = rect;
}

- (NSRange) mark;
{
	return mark;
}

- (void) setMark: (NSRange) range;
{
	mark = range;
}

- (NSSelectionGranularity) bufferGranularity;
{
	return bufferGranularity;
}

- (void) setBufferGranularity: (NSSelectionGranularity) gran;
{
	bufferGranularity = gran;
}

- (NSDate *) lastUpdate 
{
	// we need to set a default
	if ( !lastUpdate ) 
	{
		[self setLastUpdate: [NSDate distantPast]];
	}
	
	return lastUpdate;
}

- (void) setLastUpdate: (NSDate *) when 
{
	[lastUpdate autorelease];
	lastUpdate = [when retain];
}

- (void)dealloc 
{	
	[super dealloc];
}


@end
