//
//  vAOCommand.m
//  viAllOver
//
//  Copyright (c) 2005-2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 


#import "vAOCommand.h"
#import "vAOConstants.h"


@implementation vAOCommand

//static BOOL DEBUG = FALSE;


- (id)init: (NSString *) str; {
	
	self = [super init];
    if (self) {
		
		cmd = [str retain];
		
		type = [[self getType] retain];
	
		if ( nil == type ) 
		{
			return nil;
		}
		else 
		{
			if ( [type isEqualToString: @"command"] && ![[thetextview sharedData] repeatingLastEdit] && 
				![[[[thetextview sharedData] command] character] isEqualToString: cmd] )
			{
				// turn on command recording
				[[thetextview sharedData] resetRecordedCommand];
				[[thetextview sharedData] setRecordCommand:TRUE];

				// save repeat times and the command
				int rt = [[thetextview sharedData] repeatTimes];
				if ( rt > 1 )
				{
					NSString *rts = [NSString stringWithFormat:@"%d", rt];
					
					[[thetextview sharedData] addToRecordedCommand: rts];
				}
					
				[[thetextview sharedData] addToRecordedCommand: cmd];
			}
			
			return self;
		}
	}
		
	return self;
}

- (NSString *)getType; 
{
	
	// search the user dict for the command first
	NSDictionary * dict = [[vAOPrefs sharedPrefs] valueForKey: @"bindings"];
	
	int i = 0, j = 0;
	
	for ( j = 2; j > 0; j-- ) {
		NSArray * keys = [dict allKeys];

		for ( i = [keys count] - 1; i >= 0; i-- ) {
			
			//NSLog(@"checking: %@", [keys objectAtIndex:i]);
			
			if ( [[dict objectForKey: [keys objectAtIndex: i]] objectForKey: cmd] && ![[keys objectAtIndex: i] isEqualToString:@"scrolling"] ) 
			{
				type = [keys objectAtIndex: i];
				//NSLog(@"we found out type: %@", type);

				if (DEBUG) NSLog(@"cmd: %@ with type: %@, action: %@", cmd, type, [self getAction]);
				
				return type;
			}
		}
		// now lets use the default dict
		dict = [[vAOPrefs defaults] valueForKey: @"bindings"];
	}
	
	return nil;
}

- (BOOL)initAndDoItTo: (id) textview withChar: (NSString *) aString; 
{
	thetextview = [textview retain];
	
	if ( ![self init: aString] ) {
		return TRUE;
	}
	
	return [self doItTo: textview];

}

- (NSString *) character; {
	return cmd;
}

- (id)getAction 
{
	
	id action = [[[[vAOPrefs sharedPrefs] valueForKey: bindingsKey] objectForKey: type] objectForKey: cmd];	
	
//NSLog(@"user commands: %@", [[vAOPrefs sharedPrefs] valueForKey: bindingsKey]);
	if ( nil == action ) 
	{
		action = [[[[vAOPrefs defaults] valueForKey: bindingsKey] objectForKey: type] objectForKey: cmd];	
	} 
	
//NSLog(@"key: %@ has action: %@", cmd, action);
 	return action;
}


- (BOOL)isCommand {
	return ( [type compare: @"command"] == NSOrderedSame );
}

- (BOOL)isMovement {
	return ( [type compare: @"movement"] == NSOrderedSame );
}

- (BOOL)isOther {
	return ( [type compare: @"other"] == NSOrderedSame );
}

- (BOOL)isR; {
	return ( [cmd isEqualToString: @"r"] );
}

- (BOOL)isG; 
{
	return ( [cmd isEqualToString: @"G"] );
}

- (BOOL)isLineFind;
{
	return ( [cmd isEqualToString: @"f"] || [cmd isEqualToString: @"F"] || [cmd isEqualToString: @"t"] || [cmd isEqualToString: @"T"] );
}

- (BOOL) doItTo: (id) textview; 
{
	//NSLog(@"[COMMAND] new char: %@", aString);

	// check and see if we got a command
	if ( [self isCommand] ) 
	{

		if ( [[self character] isEqualToString: [[[textview sharedData] command] character]] ) 
		{
			// double commands!!
			int i, times = [[textview sharedData] repeatTimes];
			
			[textview doCommandBySelector: @selector(selectLine:)];

			// if we paste this we want to 
			//[[textview sharedData] setLinePaste: TRUE];
			
			// select a line for each additional. "3dd" this would do 2 more.
			for ( i = (times)?times:1; i > 1; i-- ) 
			{
				[textview doCommandBySelector: @selector(moveDownAndModifySelection:)];
			}

			// make sure the selection granularity is set properly
			[textview setSelectionGranularity: NSSelectByParagraph];
			
			// do the command
			[self doActionTo: textview];
			
			[[textview sharedData] setRecordCommand: NO];

			// all done here, need clean up.
			return FALSE;
		}

		if ( [[textview sharedData] visualMode] )
		{
			// we need to do the command
			[self doActionTo: textview thisManyTimes: 1];
			
			// turn visual mode off now
			[[textview sharedData] setVisualMode: FALSE]; 

		}
		else
		{
			// save it
			[[textview sharedData] setCommand: self];
		}
		
		// we are done for now
		return TRUE;
	}

	// check for a movement
	if ( [self isMovement] )
	{
		// it's time to do what ever we have in the que
		if ( [self isLineFind] || [self isG] )
			[self doActionTo: textview thisManyTimes: 1];
		else
			[self doActionTo: textview thisManyTimes: [[textview sharedData] repeatTimes] withCommand: [[textview sharedData] command]];
	}

	// check for an other
	if ( [self isOther] ) {
		// make it so
		if ( [self isR] ) {
			[self doActionTo: textview thisManyTimes: 1];
			return TRUE;
		} else {
			[self doActionTo: textview thisManyTimes: [[textview sharedData] repeatTimes]];
		}
		
	}
	
	return FALSE;
}


- (void)doActionTo: (id) txtarea {
	[self doActionTo: txtarea thisManyTimes: 0 withCommand: NULL]; 
}

- (void)doActionTo: (id) txtarea thisManyTimes: (int) times; {
	[self doActionTo: txtarea thisManyTimes: times withCommand: NULL]; 
}

- (void)doActionTo: (id) textview thisManyTimes: (int) times withCommand: (vAOCommand *) command; {
	
   // look-up the command
	id theAction = [self getAction];
	
	// check the command, if not try the last char
	if ( !theAction ) {
		return;
	}

	[self doAction: theAction to: textview thisManyTimes: times withCommand: command];
}

- (void)doAction: (id) action to: (id) textview thisManyTimes: (int) times withCommand: (vAOCommand *) command; 
{
	
   // look-up the command
	id theAction = action;
	BOOL did_lineFind = NO;
	
	// check the command, if not try the last char
	if ( !theAction ) {
		return;
	}
	
	
/*
if ( DEBUG) NSLog(@"visual: %d, class: %@, action: %@", [[textview sharedData] visualMode], [theAction class], theAction);
	if ( [[textview sharedData] visualMode] && [theAction isKindOfClass: [vAOCommand class]] && [theAction isMovement] )
	{
		return;
	}
*/	
	
	// check and see if its an alias
	if ( [theAction isKindOfClass: [NSString class]] && [vAOCommand isAlias: theAction] ) 
	{
		NSString *theActionString = theAction;
		
		// what to do?
		unsigned int i;
		unsigned int strLen = [theActionString length];

if ( DEBUG) NSLog(@"alias: %@", theActionString);
		
		// make each character a command  
		for ( i = 0; i < strLen; i++ ) 
		{
			[[vAOCommand alloc] initAndDoItTo: textview 
				withChar: [theActionString substringWithRange: NSMakeRange(i, 1)]];
		}
		
		return;
	}
	
//NSLog(@"got key command: %d", [self isKeyCommand: theAction]);
	if ( [theAction isKindOfClass: [NSString class]] && [vAOCommand isKeyCommand: theAction] ) 
	{
		[self sendKeyCommandFromString: theAction];
		return;
	}
	
	// there is always at least one selector for a command
	int selectorListCount = 1;
	
	// is it an array of selectors
	if ( [theAction isKindOfClass: [NSArray class]] ) 
	{
		selectorListCount = [theAction count];
	}
	
	// we need somewhere to put the selectors
	SEL selectorList[selectorListCount];
	selectorList[0] = nil;
	
	
	if ( [theAction isKindOfClass: [NSArray class]] )
	{
		// look up the selectors
		int i;
		
		for ( i = 0; i < selectorListCount; i++ )
		{
			if (DEBUG) 
				NSLog(@"[COMMAND array] %d: %d %@: %@", i, [[textview sharedData] repeatTimes], 
				  [self character], [theAction objectAtIndex: i]);
			
			selectorList[i] = NSSelectorFromString([theAction objectAtIndex: i]);
		}
	}
	else if ( [theAction isKindOfClass: [NSString class]] )
	{
		if (DEBUG) 
			NSLog(@"[COMMAND string] %d %@: %@", [[textview sharedData] repeatTimes], 
			  [self character], theAction);
		
		selectorList[0] = NSSelectorFromString(theAction);
	}
	
	// if we found a selector lets do it
	if ( selectorList[0] )
	{
		if ( command ) {
			// set the mark
			if ( ![[textview sharedData] visualMode] )
			{
				if (DEBUG) NSLog(@"setting the mark: %@", NSStringFromRange([textview selectedRange]));
				[textview doCommandBySelector: NSSelectorFromString(@"setMark:")];
				//[[textview sharedData] setMark: [textview selectedRange]]
			}
		}
		
		int i, rt = (times)?times:1;
			
		// now repeat
		for ( i = 0; i < rt; i++ )
		{
			int j;
			for ( j = 0; j < selectorListCount; j++ )
			{
				if ( selectorList[j] )
				{
					SEL s = selectorList[j];
					NSString *ss = NSStringFromSelector(s);
					
					if ( [vAOCommand isInsertText: ss] )
					{
						[textview insertTextNow: [ss substringFromIndex:12]];
					}
					else if ( [vAOCommand isSelector: ss] )
					{
						if ( [[textview sharedData] visualMode] && !command && [self isMovement] )
						{
							NSString *nss = [[ss substringToIndex: [ss length] - 1] stringByAppendingString:@"AndModifySelection:"];
							
							s = NSSelectorFromString(nss);
						}
						
						if (DEBUG) 
							NSLog(@"running selector: %d/%d %@", j + 1, selectorListCount,
							  NSStringFromSelector(s));
						
						[textview doCommandBySelector: s];
					}
					else
					{
						// allow keycommands and aliases in the array with selectors
						[self doAction: ss to: textview thisManyTimes: times withCommand: nil];
					}
				}
				
			}
		}
		
		if ( command ) {
			// set the mark
			if ( ![[textview sharedData] visualMode] )
			{
				if (DEBUG) NSLog(@"selecting to mark");
				[textview doCommandBySelector: @selector(selectToMark:)];
			}
			
			// make sure we turn visual mode off
	//if (DEBUG) NSLog(@"turn visual mode off");
			//[[textview sharedData] setVisualMode: FALSE];

			// do the command
			[command doActionTo: textview];

			if ( [[textview sharedData] commandMode] )
			{
				// turn off command recording
				[[textview sharedData] setRecordCommand: NO];
			}
		}
		
		
	}
	else
	{
		return;// FALSE;
	}
	
	return;// TRUE;
}	

- (void)sendKeyCommandFromString:(NSString *)command;
 {
	int i;
	NSString *character;
	unsigned int modifiers = 0;
	BOOL escaped = NO, escape = NO;
	
	// check for command keys until there are no more
	int cmdLength = [command length];
	for ( i = 0; i < cmdLength; i++ )
	{
		character = [command substringWithRange: NSMakeRange(i, 1)];
		
		if ( !escaped ) 
		{
			if ( [character isEqualToString: @"/"] ) 
			{
				if ( escape )
				{
					escaped = YES;
					escape = NO;
				}
				else
					escape = YES;
			}
			else if ( [character isEqualToString: commandKey] ) 
				modifiers |= NSCommandKeyMask;
			else if ( [character isEqualToString: optionKey] ) 
				modifiers |= NSAlternateKeyMask;
			else if ( [character isEqualToString: controlKey] ) 
				modifiers |= NSControlKeyMask;
			else if ( [character isEqualToString: shiftKey] ) 
				modifiers |= NSShiftKeyMask;
		}
		
	}

//NSLog(@"sending char: %@", character);
	
	// make the event
	NSEvent * e = [NSEvent keyEventWithType: NSKeyDown 
		location: NSMakePoint(0,0) 
		modifierFlags: modifiers 
		timestamp: 0 //[NSDate timeIntervalSinceReferenceDate]
		windowNumber: 0 //[self window]
		context: [NSGraphicsContext currentContext] //[NSGraphicsContext graphicsContextWithWindow: [self window]]
		characters: character
		charactersIgnoringModifiers: [character lowercaseString]
		isARepeat: NO
		keyCode: nil];
	
	// make sure it's good and send it
	if  (e != nil)
		[NSApp sendEvent: e];

}


+ (BOOL)isSelector: (NSString *)str; 
{
	
	if ( [str hasSuffix: @":"] ) 
	//if ( [str rangeOfString:@":"] )
	{
		return TRUE;
	}
	
	return FALSE;
}

+ (BOOL)isInsertText: (NSString *)str; 
{
	
	if ( [str hasPrefix: @"insertText: "] ) 
	//if ( [str rangeOfString:@":"] )
	{
		return TRUE;
	}
	
	return FALSE;
}

+ (BOOL)isKeyCommand: (NSString *)str; 
{
//NSLog(str);
	if ( [str hasPrefix: commandKey] || [str hasPrefix: optionKey] || [str hasPrefix: controlKey] || [str hasPrefix: shiftKey] ) {
		return TRUE;
	}
	
//NSLog(@"not a key command");	
	return FALSE;
}

+ (BOOL)isAlias: (NSString *)str; {
	return (![self isSelector: str] && ![self isKeyCommand: str] && ![self isInsertText: str] );
}

- (void)dealloc {
	[cmd release];
	[type release];
	
	cmd = nil;
	type = nil;
	
	[super dealloc];
}


@end
