//
//  vAOCommand.h
//  viAllOver
//
//  Copyright (c) 2005-2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/ 

#import <Cocoa/Cocoa.h>

#import "vAOTextView.h"

@class vAOTextView;

//BOOL DEBUG = TRUE;

@interface vAOCommand : NSObject 
{
	vAOTextView *thetextview;
	NSString * cmd;
	NSString * type;

}

- (id)init: (NSString *) str;
- (BOOL)initAndDoItTo: (id) textview withChar: (NSString *) aString;

- (NSString *) character;

- (BOOL) doItTo: (id) textview;

- (id)getAction;
- (NSString *)getType; 

- (void)doActionTo: (id) txtarea;
- (void)doActionTo: (id) txtarea thisManyTimes: (int) times; 
- (void)doActionTo: (id) txtarea thisManyTimes: (int) times withCommand: (vAOCommand *) command;
- (void)doAction: (id) action to: (id) textview thisManyTimes: (int) times withCommand: (vAOCommand *) command;

- (void)sendKeyCommandFromString:(NSString *)command;

- (BOOL)isCommand;
- (BOOL)isMovement;
- (BOOL)isOther;

- (BOOL)isR;
- (BOOL)isG; 
- (BOOL)isLineFind;

+ (BOOL)isSelector: (NSString *)str;
+ (BOOL)isAlias: (NSString *)str;
+ (BOOL)isKeyCommand: (NSString *)str; 
+ (BOOL)isInsertText: (NSString *)str; 


@end
