//
//  vAOColorTransformer.m
//  viAllOver
//
//  Copyright (c) 2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 


#import "vAOColorTransformer.h"


@implementation vAOColorTransformer
 
+ (Class)transformedValueClass
{
    return [NSDictionary self];
}
 
+ (BOOL)allowsReverseTransformation
{
    return YES;
}
 
- (id)transformedValue:(id)beforeObject
{
    if (beforeObject == nil) return nil;
	
	if ( [beforeObject isKindOfClass: [NSColor class]] )
	{
		// make a dict
		NSDictionary *dict = [NSDictionary dictionaryWithObjectsAndKeys: 
			[NSNumber numberWithFloat: [beforeObject redComponent]], @"red",
			[NSNumber numberWithFloat: [beforeObject greenComponent]], @"green",
			[NSNumber numberWithFloat: [beforeObject blueComponent]], @"blue",
			//[NSNumber numberWithFloat: [beforeObject alphaComponent]], @"alpha",
			NULL];
		
		return dict;
	}
	else if ( [beforeObject isKindOfClass: [NSDictionary class]] )
	{
		// make a color
		NSColor *thisColor = [NSColor colorWithCalibratedRed:[[beforeObject objectForKey:@"red"] floatValue]
		green:[[beforeObject objectForKey:@"green"] floatValue]
		blue:[[beforeObject objectForKey:@"blue"] floatValue]
		alpha:1.0];
		
		return thisColor;
	}
	
	return nil;
}
 
@end
