//
//  vAOBindingsOutlineController.m
//  viAllOver
//
//  Copyright (c) 2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 


#import "vAOBindingsOutlineController.h"
#import "vAOPrefs.h"
#import "vAOConstants.h"

@implementation vAOBindingsOutlineController

- (void)awakeFromNib
{
//NSLog(@"indent: %@", [ourOutlineView indentationPerLevel]);
	//[ourOutlineView setIndentationPerLevel: 0.0];

}

#pragma mark	-
#pragma mark	data source

- (int)outlineView:(NSOutlineView *)outlineView numberOfChildrenOfItem:(id)item
{
	NSDictionary *bindingsDict = [[vAOPrefs defaults] valueForKey: bindingsKey];
	
	if ( item == nil )
	{
//NSLog(@"count: %d", [[bindingsDict allKeys] count]);
		return [[bindingsDict allKeys] count];
	}
	
	id data = [item valueForKey: @"data"];
//NSLog(@"count for item: %@", data);
	
	if ( data != nil )
	{
//NSLog(@"count: %d", [data count]);
		NSDictionary *userBindings = [[[vAOPrefs sharedPrefs] valueForKey: bindingsKey] valueForKey: [item valueForKey: @"key"]];
		NSMutableArray *keys = [NSMutableArray arrayWithArray: [data allKeys]];
		NSEnumerator *enumer = [userBindings keyEnumerator];
		NSString *userKey = nil;
		while ( userKey = [enumer nextObject] )
		{
			int index = [keys indexOfObject: userKey];
			if ( index == NSNotFound )
				[keys addObject: userKey];
			else
				[keys replaceObjectAtIndex: index withObject: userKey];
		}
		
		return [keys count];
	}
	
    return 1;
}
 
- (BOOL)outlineView:(NSOutlineView *)outlineView isItemExpandable:(id)item
{
	NSDictionary *bindingsDict = [[vAOPrefs defaults] valueForKey: bindingsKey];

	if ( item == nil )
		return [bindingsDict count];

	
	id data = [item valueForKey: @"data"];
//NSLog(@"is expandable: %@ %@", [data class], data);
	if ( data != nil && ( [data isKindOfClass: [NSDictionary class]] ) ) 
		return [[item valueForKey: @"data"] count];
			
    return NO;
}
 

- (id)getRootItemForKey: (NSString *)key;
{
	NSDictionary *bindingsDict = [[vAOPrefs defaults] valueForKey: bindingsKey];
	
	NSDictionary *dict = [NSDictionary dictionaryWithObjectsAndKeys:
		key, @"key",
		[bindingsDict valueForKey: key], @"data", 
		[NSNumber numberWithBool: YES], @"root",			
		nil];
	return dict;

}

- (id)outlineView:(NSOutlineView *)outlineView
    child:(int)index
    ofItem:(id)item
{
	
    if (item == nil) 
	{
		NSDictionary *bindingsDict = [[vAOPrefs defaults] valueForKey: bindingsKey];
		
		NSString *key = [[[bindingsDict allKeys] sortedArrayUsingSelector:@selector(compare:)] objectAtIndex: index];

		NSDictionary *newRootItem = [[self getRootItemForKey: key] retain];
		
		if ( [key isEqualToString: bindingsOtherKey] )
		{
			// save a reference to the other node for adding with no selection
			otherItem = newRootItem;
		}
		
 		return newRootItem;
	}

	id localItem = [item valueForKey: @"data"];
	
//NSLog(@"get child: %d, of item %@", index, localItem);
	if ( [localItem isKindOfClass: [NSDictionary class]] )
	{
		NSDictionary *userBindings = [[[vAOPrefs sharedPrefs] valueForKey: bindingsKey] valueForKey: [item valueForKey: @"key"]];
		NSMutableArray *keys = [NSMutableArray arrayWithArray: [localItem allKeys]];
		NSEnumerator *enumer = [userBindings keyEnumerator];
		NSString *userKey = nil;
		while ( userKey = [enumer nextObject] )
		{
			int index = [keys indexOfObject: userKey];
			if ( index == NSNotFound )
				[keys addObject: userKey];
			else
				[keys replaceObjectAtIndex: index withObject: userKey];
		}

//NSLog(@"user bindings: %@", userBindings);
//NSLog(@"all keys: %@", keys);
		NSString *key = [[keys sortedArrayUsingSelector:@selector(caseInsensitiveCompare:)] objectAtIndex: index];
		NSMutableDictionary *dict = [[NSMutableDictionary dictionaryWithObjectsAndKeys:
			key, @"key",
			[item valueForKey: @"key"], @"type",
			item, @"parent",
			nil] retain];

		if ( [userBindings valueForKey: key] != nil )
		{
			[dict setValue: [userBindings valueForKey: key] forKey: @"data"];
		}
		else
		{
			[dict setValue: [localItem valueForKey: key] forKey: @"data"];
			[dict setValue: [NSNumber numberWithBool: YES] forKey: @"default"];
		}
		
		if ( [key isEqualToString: @"cmd"] && [[dict valueForKey: @"data"] isEqualToString: @"action:"] )
		{
//NSLog(@"new item: %@", dict);
			// save a reference to the new item
			newItem = dict;
		}
		
		return dict;
	}
	
/*	if ( [localItem isKindOfClass: [NSArray class]] )
	{
		NSDictionary *dict = [[NSDictionary dictionaryWithObjectsAndKeys:
			@"", @"key",
			[localItem objectAtIndex: index], @"data", 
			nil] retain];
//NSLog(@"for array: %@", dict);
		return dict;
	}
*/
	return nil;
}
 
- (id)outlineView:(NSOutlineView *)outlineView
    objectValueForTableColumn:(NSTableColumn *)tableColumn
    byItem:(id)item
{
    if (item == nil) 
		return @"two";


	if ( [[tableColumn identifier] isEqualToString: bindingsCommandColumn] )
	{
		if ( [item isKindOfClass: [NSString class]] )
			return item;
		
		if ( [item isKindOfClass: [NSDictionary class]] && [item valueForKey: @"key"] != nil )
			return [item valueForKey: @"key"];
	}

	if ( [[tableColumn identifier] isEqualToString: bindingsActionColumn] )
	{
		id data = [item valueForKey: @"data"];
		
		//if ( ( [data isKindOfClass: [NSString class]] && [data length] < 1 ) || [data respondsToSelector: @selector(boolValue)] && ![data boolValue] )
		//	return @"disabled";
			
		if ( [data isKindOfClass: [NSString class]] )
			return data;
		
		if ( [data isKindOfClass: [NSArray class]] )
			return [data componentsJoinedByString: @", "];

	}

//NSLog(@"outline view: %@", outlineView);
//NSLog(@"column: %@, for item %@", [tableColumn identifier], item);
//NSLog(@"column: %@", tableColumn );

	return nil;
}

- (void)outlineView:(NSOutlineView *)outlineView setObjectValue:(id)object forTableColumn:(NSTableColumn *)tableColumn byItem:(id)item
{
	//NSMutableDictionary *mutableItem = [item mutableCopy];
	
	NSMutableDictionary *oldBindings = [NSMutableDictionary dictionaryWithDictionary:
		[[vAOPrefs sharedPrefs] valueForKey: bindingsKey]];

	NSMutableDictionary *oldTypeBindings = [NSMutableDictionary dictionaryWithDictionary:
		[oldBindings valueForKey: [item valueForKey: @"type"]]];
	
//NSLog(@"saving: %@, for column: %@, key: %@, item: %@", object, [tableColumn identifier], [item valueForKey: @"key"], item);

	NSDictionary *defaultBindings = [[[vAOPrefs defaults] valueForKey: bindingsKey] valueForKey: [item valueForKey: @"type"]];

	if ( [[tableColumn identifier] isEqualToString: bindingsCommandColumn] )
	{
		if ( [[defaultBindings valueForKey: object] isEqualTo: [item valueForKey: @"data"]] )
			return;
			
		[oldTypeBindings removeObjectForKey: [item valueForKey: @"key"]];
		
		[oldTypeBindings setValue: [item valueForKey: @"data"] forKey: object];
	}

	if ( [[tableColumn identifier] isEqualToString: bindingsActionColumn] )
	{
		// check for ',''s in the string and make them into arrays if need
		if ( [object rangeOfString: @","].location != NSNotFound )
		{
			object = [self arrayFromString: object];
		}

		if ( [[defaultBindings valueForKey: [item valueForKey: @"key"]] isEqualTo: object] )
		{
//NSLog(@"already in defaults");
			if ( [oldTypeBindings valueForKey: [item valueForKey: @"key"]] != nil )
			{
//NSLog(@"removeing user default");
				[oldTypeBindings removeObjectForKey: [item valueForKey: @"key"]];
			}
			else
				return;
		}
		else
		{
			[oldTypeBindings setValue: object forKey: [item valueForKey: @"key"]];
		}
	}
	
//NSLog(@"new bindings: %@", oldTypeBindings);
	[oldBindings setValue: oldTypeBindings forKey: [item valueForKey: @"type"]];
	
	[[vAOPrefs sharedPrefs] setValue: oldBindings forKey: bindingsKey];
	
	// reload the parent object
	[ourOutlineView reloadItem: [item valueForKey: @"parent"] reloadChildren: YES];
}

#pragma mark	-
#pragma mark	array/string conversion

- (NSArray *) arrayFromString: (NSString *)str;
{
	// this needs to be smarter, in case the user doesn't use a space or more than one
	return [str componentsSeparatedByString: @", "];
}

#pragma mark	-
#pragma mark	notifications

/*
- (BOOL)selectionShouldChangeInOutlineView:(NSOutlineView *)outlineView
{
	return NO;
}
*/

- (void)outlineViewSelectionDidChange:(NSNotification *)notification
{
	int row = [ourOutlineView selectedRow];
	
	if ( row >= 0 )
	{
		id item = [ourOutlineView itemAtRow: row];
		
		if ( [item valueForKey: @"root"] != nil && [[item valueForKey: @"root"] boolValue] )
		{
			[removeButton setEnabled: NO];
			return;
		}
		
		[removeButton setEnabled: YES];
		return;
	}
	
	[removeButton setEnabled: NO];

}

#pragma mark	-
#pragma mark	actions

- (IBAction)add:(id)sender;
{
	NSString *type = bindingsOtherKey;
	id parent = otherItem;
	
	int row = [ourOutlineView selectedRow];
	
	if ( row >= 0 )
	{
		id item = [ourOutlineView itemAtRow: row];
		
		if ( [item valueForKey: @"root"] != nil && [[item valueForKey: @"root"] boolValue] )
		{
			type = [item valueForKey: @"key"];
			parent = item;
		}
		else if ( [item valueForKey: @"type"] != nil )
		{
			type = [item valueForKey: @"type"];
			parent = [item valueForKey: @"parent"];
		}
	}

	NSMutableDictionary *oldBindings = [NSMutableDictionary dictionaryWithDictionary:
		[[vAOPrefs sharedPrefs] valueForKey: bindingsKey]];

	NSMutableDictionary *oldTypeBindings = [NSMutableDictionary dictionaryWithDictionary:
		[oldBindings valueForKey: type]];
	
	[oldTypeBindings setValue: @"action:" forKey: @"cmd"];

	[oldBindings setValue: oldTypeBindings forKey: type];

	[[vAOPrefs sharedPrefs] setValue: oldBindings forKey: bindingsKey];
	
	// show the new row
	[ourOutlineView expandItem: parent];

	// reload the parent object
	[ourOutlineView reloadItem: parent reloadChildren: YES];
	
	int newRow = [ourOutlineView rowForItem: newItem];
	[ourOutlineView selectRow: newRow byExtendingSelection: NO];
	[ourOutlineView scrollRowToVisible: newRow];
	
	[[NSApp mainWindow] makeFirstResponder: ourOutlineView];
	
//NSLog(@"new item at row: %d, old row:  %d, parent: %@", newRow, row, newItem);

}

- (IBAction)remove:(id)sender;
{
	int row = [ourOutlineView selectedRow];
	
	if ( row >= 0 )
	{
		id item = [ourOutlineView itemAtRow: row];
		
		if ( [item valueForKey: @"root"] != nil && [[item valueForKey: @"root"] boolValue] )
		{
			return;
		}
		
		NSMutableDictionary *oldBindings = [NSMutableDictionary dictionaryWithDictionary:
			[[vAOPrefs sharedPrefs] valueForKey: bindingsKey]];

		NSMutableDictionary *oldTypeBindings = [NSMutableDictionary dictionaryWithDictionary:
			[oldBindings valueForKey: [item valueForKey: @"type"]]];
		
//NSLog(@"saving: %@, for column: %@, key: %@, item: %@", object, [tableColumn identifier], [item valueForKey: @"key"], item);

		//NSDictionary *defaultBindings = [[[vAOPrefs defaults] valueForKey: bindingsKey] valueForKey: [item valueForKey: @"type"]];
		
		if ( [oldTypeBindings valueForKey: [item valueForKey: @"key"]] != nil )
			[oldTypeBindings removeObjectForKey: [item valueForKey: @"key"]];
		else
			[oldTypeBindings setValue: @"" forKey: [item valueForKey: @"key"]];

		[oldBindings setValue: oldTypeBindings forKey: [item valueForKey: @"type"]];
		
		[[vAOPrefs sharedPrefs] setValue: oldBindings forKey: bindingsKey];
		
		// reload the parent object
		[ourOutlineView reloadItem: [item valueForKey: @"parent"] reloadChildren: YES];
	}
}

#pragma mark	-
#pragma mark	delagates

- (BOOL)outlineView:(NSOutlineView *)outlineView shouldEditTableColumn:(NSTableColumn *)tableColumn item:(id)item
{
	if ( [item valueForKey: @"root"] != nil && [[item valueForKey: @"root"] boolValue] )
	{
		return NO;
	}

	if ( [item valueForKey: @"default"] != nil && [[item valueForKey: @"default"] boolValue] )
	{
		//return NO;
	}

	return YES;
}

- (void)outlineView:(NSOutlineView *)outlineView willDisplayCell:(id)cell forTableColumn:(NSTableColumn *)tableColumn item:(id)item
{
	if ( [item valueForKey: @"default"] != nil && [[item valueForKey: @"default"] boolValue] )
	{
		// a default, gray it out
		[cell setTextColor: [NSColor grayColor]];
	}
	else
		[cell setTextColor: [NSColor textColor]];	
}


@end
