//
//  orgDabbleviAllOverPrefPane.m
//  viAllOver
//
//  Copyright (c) 2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 


#import "orgDabbleviAllOverPrefPane.h"
#import "vAOColorTransformer.h"

@implementation orgDabbleviAllOverPrefPane

+ (void)initialize 
{
	[super initialize];
	
	// register our color transformer
	id transformer = [[[vAOColorTransformer alloc] init] autorelease];
	[NSValueTransformer setValueTransformer:transformer forName:@"vAOColorTransformer"];
	
/*
    [self setKeys:
        [NSArray arrayWithObjects:@"animationUpdates", @"animatePosition", nil]
        triggerChangeNotificationsForDependentKey:@"limitUpdatesEnabled"];

    [self setKeys:
        [NSArray arrayWithObjects:@"animationUpdates", @"animatePosition", @"limitUpdates", nil]
        triggerChangeNotificationsForDependentKey:@"limitUpdatesFieldEnabled"];
	
	[self setKeys:
        [NSArray arrayWithObjects:@"animationUpdates", @"animatePosition", nil]
        triggerChangeNotificationsForDependentKey:@"updatesPerSecondEnabled"];
*/
}

- (id)initWithBundle:(NSBundle *)bundle
{
	self = [super initWithBundle: bundle];
	
	if ( nil != self )
	{
		// set-up the defaults
		//defaults = [ScreenSaverDefaults defaultsForModuleWithName: [[self bundle] bundleIdentifier]];
		//[defaults registerDefaults: [vAOPrefs defaults]];
		defaults = [vAOPrefs sharedPrefs];
	
	}
	
	return self;
}

- (void) willSelect // happens every time the pref pane is selected
{
	// load the defaults
	
	// locate our bundle
	NSBundle *ourBundle = [NSBundle bundleForClass: [self class]];
	
	NSArray *paths = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask | NSLocalDomainMask, YES);
	if ([paths count] > 0)  
	{
		int i;
		int count = [paths count];
		for ( i = 0; i < count; i++ )
		{
			NSString *libraryPath = [paths objectAtIndex:i];
			if ( [[ourBundle bundlePath] hasPrefix: libraryPath] )
				[self setOurLibraryPath: libraryPath];
		}
	}

if (DEBUG) NSLog(@"our library path: %@", [self ourLibraryPath]);
		
	[self setInstallImputManagerButtonTitle];
	[self setInstallPathField];
}

- (void)didUnselect
{
if (DEBUG) NSLog(@"un-selected pref pane");

	//[vAOPrefs writeUserDefaults];
	[defaults synchronize];
	
	// notify everyone that the prefs changed
	//NSString *observedObject = @"com.apple.example.PrefpaneTarget"; 
	NSDistributedNotificationCenter *center = [NSDistributedNotificationCenter defaultCenter]; 
	
	[center postNotificationName: prefChangeNotification
		object: prefChangeNotification 
		userInfo: nil /* no dictionary */ 
		deliverImmediately: YES]; 

	
}

- (BOOL) hideUninstallAndQuitButton;
{
	return !DEBUG;
}

#pragma mark	-
#pragma mark	inputmanager (un)install

- (void) setInstallImputManagerButtonTitle;
{
	if ( [self isInputManagerInstalled] )
	{
		[installButton setTitle: @"Uninstall InputManager"];
	}
	else
	{
		[installButton setTitle: @"Install InputManager"];
	}
}

- (void) setInstallPathField;
{
	NSString *path = [self getInputManagerPath];
	
	if ( path == nil )
	{
		path = [[self ourLibraryPath] stringByAppendingPathComponent: @"InputManagers"];
		[installStatusField setStringValue: @"InputManager will be installed in:"];
	}
	else
	{
		[installStatusField setStringValue: @"InputManager is installed in:"];
	}
	
	[installPathField setStringValue: path];
}

- (BOOL) isInputManagerInstalled;
{
	return ( nil != [self getInputManagerPath] );
}

- (BOOL) isInputManagerInstalledInDomain: (NSSearchPathDomainMask) domain;
{
	NSArray *paths = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, domain, YES);
	
	if ([paths count] > 0)  
	{
		NSString *theInputManagerPath = [self getInputManagerPath];

		if ( nil != theInputManagerPath && [theInputManagerPath hasPrefix: [paths objectAtIndex: 0]] )
		{	
			return YES;
		}
   }

	return NO;
}

- (NSString *) getInputManagerPath;
{
	NSString *inputManagerBundle = @"/viAllOver";
	
	NSString *inputManagerPath = @"/InputManagers";

    NSFileManager *mgr = [NSFileManager defaultManager];
 
	NSArray *paths = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask | NSLocalDomainMask, YES);
	if ([paths count] > 0)  
	{
		int i;
		int count = [paths count];
		for ( i = 0; i < count; i++ )
		{
			NSString *theInputManagerPath = [[paths objectAtIndex:i] stringByAppendingPathComponent: inputManagerPath];
			NSString *path = [theInputManagerPath stringByAppendingString: inputManagerBundle];

			if ( [mgr fileExistsAtPath: path] )
			{	
				return path;
			}
		}
	}
	
	return nil;
}


- (IBAction)uninstallPrefPaneAndQuit:(id)sender;
{
	// extreamly handy for testing, worth every minute
	
	// remove the pref pane
	NSFileManager *mgr = [NSFileManager defaultManager];

	NSString *prefPanePath = [[self bundle] bundlePath];
NSLog(@"remove pref pane from: %@", prefPanePath);

	[mgr removeFileAtPath: prefPanePath handler: nil];
	
	// quit
	[NSApp doCommandBySelector: @selector(terminate:)];
}


- (IBAction)installInputManagerAction:(id)sender;
{
	NSFileManager *mgr = [NSFileManager defaultManager];

	if ( [self isInputManagerInstalled] )
	{
		// uninstall
		NSString *path = [self getInputManagerPath];
		
//NSLog(@"uninstalling: %@", path);

		if ( [mgr isDeletableFileAtPath: path] )
			[mgr removeFileAtPath: path handler: nil];			
	}
	else
	{
		// install
		NSBundle *ourBundle = [NSBundle bundleForClass: [self class]];
		NSString *fromPath = [[ourBundle resourcePath] stringByAppendingPathComponent: @"viAllOver"];
		
		NSString *toPath = [[self ourLibraryPath] stringByAppendingPathComponent: @"InputManagers/viAllOver"];
				
//NSLog(@"copy from: %@, to: %@", fromPath, toPath);
		[mgr copyPath: fromPath toPath: toPath handler: self];
	}

	[self setInstallImputManagerButtonTitle];
	[self setInstallPathField];

}

- (BOOL)fileManager:(NSFileManager *)manager shouldProceedAfterError:(NSDictionary *)errorInfo
{
	NSLog(@"error: %@", errorInfo);
	
	return NO;
}

#pragma mark	-
#pragma mark	key value coding

- (NSString *) ourLibraryPath;
{
	return ourLibraryPath;
}

- (void) setOurLibraryPath: (NSString *)path;
{
	if ( nil != ourLibraryPath )
		[ourLibraryPath release];
	
	ourLibraryPath = [path retain];
}

#pragma mark	-
#pragma mark	exclude list additions

- (IBAction)addExcludedApp:(id)sender;
{
	// pop open panel as a sheet
	[self popOpenSheet];
}

- (void) popOpenSheet;
{
	NSOpenPanel * panel = [NSOpenPanel openPanel];

	[panel beginSheetForDirectory:nil
						   file:nil
						  types:[NSArray arrayWithObjects:@"app",nil]
				 modalForWindow:[[self mainView] window]
				  modalDelegate:self
				 didEndSelector:@selector(filePanelDidEnd:
											   returnCode:
											  contextInfo:)
					contextInfo:nil];
}

-(void)filePanelDidEnd:(NSOpenPanel*)sheet
            returnCode:(int)returnCode
           contextInfo:(void*)contextInfo 
{
	//[self setUserDirectoryFromFilename:[sheet filename]];
	//NSLog(@"selected %@", [[sheet filenames] objectAtIndex:0]);
	// add the new excluded app to the list
	
	NSString *appPath = [[sheet filenames] objectAtIndex:0];
	
	NSBundle *appBundle = [NSBundle bundleWithPath:appPath];
	
	NSString *appIdentifier = [appBundle bundleIdentifier];
	
	//NSLog(@"bundle info: %@", [appBundle infoDictionary]);
		
	NSArray *appPathParts = [appPath pathComponents];
	
	NSString *appName = [[appPathParts objectAtIndex: [appPathParts count] - 1] stringByDeletingPathExtension];

	//NSLog(@"%@ - %@", appName, appIdentifier);
	// refresh the list

	NSDictionary *newApp = [NSDictionary dictionaryWithObjectsAndKeys:appName, @"name", appIdentifier, @"id", nil];

	//NSMutableArray *xList = [NSMutableArray arrayWithArray: [[vAOPrefs sharedPrefs] valueForKey:@"exclude"]];
	NSMutableArray *xList = [[vAOPrefs sharedPrefs] mutableArrayValueForKey: @"exclude"];
	
	int selectedRow = 0;
	
	if ( ![xList containsObject:newApp] )
	{
		[xList addObject:newApp];

		//NSLog(@"new app: %@ for the exclude apps list: %@", newApp, xList);
		
		//[[vAOPrefs sharedPrefs] setValue:xList forKey:@"exclude"];

		//[excludeTableView reloadData];
		
		selectedRow = [xList count]-1;
	}
	else
	{
		selectedRow = [xList indexOfObject:newApp];
	}

	//[excludeTableView setNeedsDisplay: YES];
	[excludeTableView reloadData];
	[excludeTableView selectRow:selectedRow byExtendingSelection:NO];

//NSLog(@"oi: %@", [[vAOPrefs sharedPrefs] observationInfo]);
	//[[vAOPrefs sharedPrefs] didChangeValueForKey: @"exclude"];
	
}


#pragma mark	-
#pragma mark	tableview delagates

- (BOOL)tableView:(NSTableView *)aTableView shouldEditTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	if ( [aTableView isEqualTo: excludeTableView] )
	{
			return NO;
	}
	
	return YES;
}



@end
