//
//  orgDabbleviAllOverPrefPane.h
//  viAllOver
//
//  Copyright (c) 2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 


#import <Cocoa/Cocoa.h>
#import <PreferencePanes/NSPreferencePane.h>
#import <ScreenSaver/ScreenSaverDefaults.h>

#import "vAOPrefs.h"
#import "vAOConstants.h"

@interface orgDabbleviAllOverPrefPane : NSPreferencePane
{
	NSString *ourLibraryPath;
	vAOPrefs *prefs;
	vAOPrefs *defaults;
	
    IBOutlet NSButton *installButton;
    IBOutlet NSTextField *installPathField;
    IBOutlet NSTextField *installStatusField;
	IBOutlet NSTableView *excludeTableView;
}

- (IBAction)installInputManagerAction:(id)sender;
- (IBAction)addExcludedApp:(id)sender;
- (IBAction)uninstallPrefPaneAndQuit:(id)sender;

- (void) popOpenSheet;

- (BOOL) hideUninstallAndQuitButton;

- (NSString *) ourLibraryPath;
- (void) setOurLibraryPath: (NSString *)path;

- (BOOL) isInputManagerInstalled;
- (BOOL) isInputManagerInstalledInDomain: (NSSearchPathDomainMask) domain;
- (NSString *) getInputManagerPath;

- (void) setInstallImputManagerButtonTitle;
- (void) setInstallPathField;

@end
