//
//  vAOTextView.m
//  viAllOver
//
//  Copyright (c) 2004-2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 



#import "vAOTextView.h"
//#import <WebKit/WebFrameLoadDelegate.h>

@implementation vAOTextView

static BOOL DEBUG = FALSE;
//#define DEBUG 1;

#define viAllOverPasteboardType @"viAllOverPasteboardType"

+ (void)load
{
	// check for apps to exclude			

	NSBundle * b = [NSBundle mainBundle];
	NSLog(@"viAllOver is trying to load for %@", [b bundleIdentifier]);

	NSArray *userExcludes = [[self getUserDefaultsDict] objectForKey:@"exclude"];
	if ( userExcludes && [userExcludes containsObject: [b bundleIdentifier]] )
	{
		return;
	}
		
	NSArray *defaultExcludes = [[self getDefaultsDict] objectForKey:@"exclude"];
	if ( defaultExcludes && [defaultExcludes containsObject: [b bundleIdentifier]] )
	{
		return;
	}
			
	NSLog(@"loading vAOTextView");
	
	
	// time to take over the world
	[[self class] poseAsClass:[NSTextView class]];	
	
	// attempting to make work in mail again
	//[[self class] poseAsClass:[WebView class]];		
    
}

- (id)initWithFrame:(NSRect)frameRect
{
	self = [super initWithFrame:frameRect];
	
    if (self) {
        // Initialization code here.
		
		// default to insert mode!
		[[self sharedData] setCommandMode: FALSE];
		
		// visual mode off
		[[self sharedData] setVisualMode: FALSE];
		
		[[self sharedData] setRepeatTimes: 0];
		
		[[self sharedData] setInsertionPointLock: FALSE];

	}
	
    return self;
	
}

- (void)keyDown:(NSEvent *)theEvent
{
    // print keyCodes in the textview
    //[super insertText: [[NSNumber numberWithUnsignedShort: [theEvent keyCode]] stringValue]];
	
	BOOL modifiers = FALSE;

    if ( ([theEvent modifierFlags] & NSAlphaShiftKeyMask) ||
		 ([theEvent modifierFlags] & NSShiftKeyMask) ||
		 ([theEvent modifierFlags] & NSControlKeyMask) ||
		 ([theEvent modifierFlags] & NSAlternateKeyMask) ||
		 ([theEvent modifierFlags] & NSCommandKeyMask) ) {
		
		modifiers = TRUE;
	}

    // need to check for escape key here, so we can switch modes
	// [esc] keyCode -> 53
    if ( [theEvent keyCode] == 53 && !modifiers )
    {
		// switch to command mode
		[[self sharedData] setCommandMode: TRUE];
		
		// turn off visiual mode
		[[self sharedData] setVisualMode: FALSE];
		
		// turn off command recording
		[[self sharedData] setRecordCommand: FALSE];
		//[[self sharedData] resetRecordedCommand];
		
		[self setNeedsDisplay:YES];
    }
	else if ( [theEvent keyCode] == 51 && !modifiers ) // backspace
	{
		if ( [[self sharedData] commandMode] )
		{
			[self doCommandBySelector: @selector(moveLeft:)];
		}
		else
		{
			if ( [[self sharedData] recordCommand] )
			{
				// pop the last char added
				[[self sharedData] popFromRecordedCommand];
				
			}

			// send the backspace to the field
			[super keyDown: theEvent];
		}
	}
    else
    {
		[super keyDown: theEvent];
    }
}

- (void)insertText:(id)aString
{   

///* if (DEBUG) */ NSLog(@"key: %@, recording: %d", aString,  [[self sharedData] recordCommand]);

	if ( [[self sharedData] recordCommand] )
	{
		[[self sharedData] addToRecordedCommand: aString];
	}
	
    if ( [[self sharedData] isSpecialMode: @"r"] )
    {
		//NSLog(@"got the replace char");
		
		// get number of times to repeat
		int times = [[self sharedData] repeatTimes];
		int i, rt = (times)?times:1 ;
		
		// now repeat
		for ( i = 0; i < rt; i++ )
		{
			// select the next character to the right
			[self doCommandBySelector: @selector(moveRightAndModifySelection:)];
			
			// replace selected character with new one from user
			[super insertText: aString];
		}
		
		// turn off replace mode
		[[self sharedData] setSpecialMode: @""];
		[[self sharedData] setRepeatTimes: 0];
		
		return;
	}
		
    if ( [[self sharedData] isSpecialMode: @"f"] || [[self sharedData] isSpecialMode: @"F"] || 
		[[self sharedData] isSpecialMode: @"t"] || [[self sharedData] isSpecialMode: @"T"] )
    {
		NSString *findThis = aString;
		NSString *findMode = [[self sharedData] specialMode];
		
if (DEBUG) NSLog(@"searching for: %@", findThis);
		BOOL modify = false;
		BOOL backward = false;
		unsigned searchMask = 0;
		unsigned int strLength = [[self string] length];
		
		// get number of times to repeat
		int times = [[self sharedData] repeatTimes];
		int i, rt = (times)?times:1 ;
		
		if ( [[self sharedData] isSpecialMode: @"F"] ||
			[[self sharedData] isSpecialMode: @"T"] )
		{
if (DEBUG) NSLog(@"backwards");
			backward = true;
			searchMask |= NSBackwardsSearch;
		}
		
if (DEBUG) NSLog(@"command: %@", [[self sharedData] command]);
		if ( [[self sharedData] visualMode] )
			modify = TRUE;
		else if ( [[self sharedData] command] )
		{
//NSLog(@"setting mark");
			//[self setMark:nil];
			modify = TRUE;
		
		}
			
		NSRange lookHere = [self get_new_lookHere_location_forSelectionModification: modify backward: backward];

		// now repeat
		for ( i = 0; i < rt; i++ )
		{
			lookHere.location += 1;
			lookHere.length -= 1;
///* if (DEBUG) */ NSLog(@"%d.1 lookHere: %@", i, NSStringFromRange(lookHere));
			
			lookHere = [[self string] rangeOfString: findThis options: searchMask range: lookHere];
		
///* if (DEBUG) */ NSLog(@"%d.2 lookHere: %@", i, NSStringFromRange(lookHere));
			if ( lookHere.location != NSNotFound ) 
			{
				
				if ( [[self sharedData] isSpecialMode: @"t"] && i == rt - 1)
				{
///* if (DEBUG) */ NSLog(@"tee");
					lookHere.location -= 1;
				} else if ( [[self sharedData] isSpecialMode: @"T"] && i == rt - 1)
				{
///* if (DEBUG) */ NSLog(@"TEE");
					lookHere.location += 1;
				}
				
				[self select_new_Range: lookHere forSelectionModification: modify];
				
				if ( backward )
				{
					lookHere.length = lookHere.location;
					lookHere.location = 0;
				}
				else
					lookHere.length = strLength - lookHere.location;
			}
			else
			{
				// not found, we should probably beep
				NSBeep();
			}
		}
		
		// turn off replace mode
		[[self sharedData] setSpecialMode: @""];
		[[self sharedData] setRepeatTimes: 0];

		if ( [[self sharedData] command] )
		{
if (DEBUG) NSLog(@"going to run the command");
			//[self selectToMark:nil];
			//[self vAO_visualMode:nil];
			[[self sharedData] setVisualMode: @"v"]; 
			vAOCommand *theCommand = [[self sharedData] command];
			[[self sharedData] setCommand: NULL];
			[theCommand doItTo:self];
			[[self sharedData] setVisualMode: FALSE]; 
		}
		
		return;
	}
		
	if ( [[self sharedData] commandMode] )
	{	    
	    // check for new lines and forget them
	    if ( [aString isEqualToString: @"\n"] )
	    {
			//[super insertText: aString];
		    return;
	    }

		// check for repeat numbers
	    if ( [aString intValue] > 0 || 
			 ( [[self sharedData] repeatTimes] > 0 && [aString isEqualToString: @"0"]) )
	    {
		    // it's a number, add prevous digits togeather
		    [[self sharedData] setRepeatTimes: 
				(10 * [[self sharedData] repeatTimes]) + [aString intValue]];

		    //NSLog(@"[COMMAND] %d", [[self sharedData] repeatTimes]);

		    return;
	    }
	    
	    // we are always going to repeat at least once
	    if ( [[self sharedData] repeatTimes] < 1 ) {
		    [[self sharedData] setRepeatTimes: 1];
	    }
		
		// try and make a new cammand from the character
		vAOCommand * newCmd = [vAOCommand alloc];
		if (  [newCmd initAndDoItTo: self withChar: aString] ) {
			return;
		}
		
		BOOL nix_command = ![newCmd isLineFind];
			
		
		//NSLog(@"done commanding.");
	    
	    // all done, reset repeatTimes, only if not a line find
		if ( ![newCmd isLineFind] )
			[[self sharedData] setRepeatTimes: 0];
			
		[newCmd release];
		
		if ( nix_command )
			[[self sharedData] setCommand: NULL];
		
		//[[self sharedData] setRecordCommand:NO];
		//[[self sharedData] resetRecordedCommand];

	}
    else
    {
		// not in command mode, just insert the characters normaly.
		[super insertText: aString];
    }
}

- (void)drawViewBackgroundInRect:(NSRect)aRect
{
	//NSLog(@"drawViewBackgroundInRect: %@", NSStringFromRect(aRect));
	
	[super drawViewBackgroundInRect: aRect];
	
	// now draw our insertion point behind the text
	NSRect caretRect = [self getInsertionPointRect];
	if ( ![self isHidden] && [self isEditable] && NSIntersectsRect(aRect, caretRect) ) 
	{
		[self drawInsertionPointInRect: caretRect color: [self insertionPointColor] turnedOn: TRUE];
	}
}

- (void)updateInsertionPointStateAndRestartTimer:(BOOL)flag {

	if ( [self canDraw] && ![[self sharedData] insertionPointLock]) {		
		
		// we need to have lock because the "textContainerOrigin" method seem to 
		// make "updateInsertionPointStateAndRestartTimer" get called.
		[[self sharedData] setInsertionPointLock: TRUE];
		
		// have the insertion point updated next time
		[self setNeedsDisplayInRect: [self getInsertionPointRect]];
		
		// the following fixed a redraw problem, where the old cursor wasn't getting cleared
		[self setNeedsDisplayInRect: [[self sharedData] oldInsertionPointRect]];
		
		[[self sharedData] setInsertionPointLock: FALSE];
	}
}

- (NSRect)getInsertionPointRect 
{
	unsigned int here = [self selectedRange].location;
	int strLen = [[self string] length];
	
	//NSLog(@"checking here: %d", here);
	
	//NSLog(@"inset: %@", NSStringFromSize([self textContainerInset]));
	//NSLog(@"origin: %@", NSStringFromPoint([self textContainerOrigin]));
	
	NSRect caretRect = NSZeroRect;
	
	
	static NSMutableCharacterSet *newLineCharSet = nil;
	if ( nil == newLineCharSet )
	{
		newLineCharSet = [[NSCharacterSet whitespaceAndNewlineCharacterSet] mutableCopy];
		NSCharacterSet *notWhitespaceCharSet = [[NSCharacterSet whitespaceCharacterSet] invertedSet];
		[newLineCharSet formIntersectionWithCharacterSet: notWhitespaceCharSet];
	}
		
//NSLog(@"newlines: %@", newLineCharSet);
//NSLog(@"newline: %d", [newLineCharSet characterIsMember:'\n']);
//NSLog(@"other: %d", [newLineCharSet characterIsMember:'x']);
//NSLog(@"space: %d", [newLineCharSet characterIsMember:' ']);
	
	if ( strLen == 0 ) 
	{
		// empty textview
		caretRect = [self getStandardInsertionPointRect];
	} 
	else if ( here == strLen ) 
	{
		// when we are at the end of the line.

		here = here - 1;

		//NSLog(@"at the end of the line.");

//NSLog(@"char: %d", (unsigned int)[[self string] characterAtIndex: here]);

		//if ( [[self string] characterAtIndex: here] == '\n' ) 
		if ( [newLineCharSet characterIsMember: [[self string] characterAtIndex: here] ] ) 
		{
			//NSLog(@"newline here");
			// on a new line
			caretRect = [self getStandardInsertionPointRect];
		}
		else 
		{

			NSRect charBox = [self rectForCharacterIndex: here];

			// draw the caret in the next slot over
			charBox.origin.x = charBox.origin.x + charBox.size.width;
			charBox.size.width = [self getDefaultCaretWidth];
			
			caretRect = charBox;
		}
		
	} 
	else if ( here >= 0 && here < strLen ) 
	{
		// any where in the middle of the string

		NSRect charBox = [self rectForCharacterIndex: here];
		
		if ( [newLineCharSet characterIsMember: [[self string] characterAtIndex: here] ] ) 
		{
			//NSLog(@"newline here 2");
			// see if prevous char was a newline ask the layout mananger where to draw
			charBox.size.width = [self getDefaultCaretWidth];
		}
		else if ( NSIsEmptyRect(charBox) ) 
		{
			charBox = [[self layoutManager] extraLineFragmentUsedRect];
		} 
//NSLog(@"char: %d, %@", (unsigned int)[[self string] characterAtIndex: here], NSStringFromRect(charBox));
		
		if ( charBox.size.width == 0 )
			charBox.size.width = [self getDefaultCaretWidth];
			
		caretRect = charBox;
	}
	
	//[newLineCharSet release];
	
	return NSOffsetRect(caretRect, [self textContainerOrigin].x, [self textContainerOrigin].y);
}

- (NSRect)getStandardInsertionPointRect
{
	NSRect r = [[self layoutManager] extraLineFragmentUsedRect];
	
	// get the real insertion point
	r.origin.x = r.origin.x + ( r.size.width / 2 );
	
	r.size.width = [self getDefaultCaretWidth];
	
	return r;
}

- (int)getDefaultCaretWidth
{
	// we need to come up with a way to look this up based one the font.
	// but this is perfect in smultron and xcode (fixed width)
	return  6;
}

- (void)drawInsertionPointInRect:(NSRect)aRect color:(NSColor *)aColor turnedOn:(BOOL)flag 
{	
	// have the old one cleared
	[self setNeedsDisplayInRect: [[self sharedData] oldInsertionPointRect]];
	
	// a nice transparent color
	[[aColor colorWithAlphaComponent:0.40] set];
	
	//NSLog(@"drawing insertion point at: %@", NSStringFromRect(aRect));
	
	// accually draw the caret
	[[NSBezierPath bezierPathWithRect: aRect] fill];
	
	// save the old one so we can make sure it has been cleared
	[[self sharedData] setOldInsertionPointRect: aRect];	

}

- (BOOL)shouldDrawInsertionPoint;
{
	return YES;
}

- (NSColor *) insertionPointColor 
{
	
	NSColor * thisColor;
	
	// pick the color
	if ([[self window] firstResponder] != self) 
	{ 
		// inactive
		thisColor = [self getColorWithName:@"inactive"]; 
		//thisColor = [NSColor blackColor]; 
	} 
	else if ( [[self sharedData] visualMode] )
	{
		// visual mode
		thisColor = [self getColorWithName:@"visual"];
	}
	else if ( [[self sharedData] commandMode] )
	{
		// command mode
		thisColor = [self getColorWithName:@"command"];
	}
	else
	{
		// insert mode
		thisColor = [self getColorWithName:@"insert"];
	}
	
	return thisColor;
}

- (NSDictionary *)selectedTextAttributes;
{
	NSDictionary *atts = [super selectedTextAttributes];	
//NSLog(@"getting selectedTextAttributes %@", atts);

//NSLog(@"background: %@, alpha: %@", [atts objectForKey:NSBackgroundColorAttributeName], [[atts objectForKey:NSBackgroundColorAttributeName] alphaComponent]);
//NSLog(@"foreground: %@", [atts objectForKey:NSForegroundColorAttributeName]);

	// makes it very pretty, we'll make it a little darker too
	NSColor *newBack = [[self backgroundColor] blendedColorWithFraction:0.5 ofColor:[self insertionPointColor]];
	
	NSDictionary *newAtts = [NSDictionary dictionaryWithObjectsAndKeys: 
		newBack, NSBackgroundColorAttributeName, 
		[atts objectForKey:NSForegroundColorAttributeName], NSForegroundColorAttributeName, 
		nil];

//NSLog(@"setting selectedTextAttributes %@", newAtts);

	return newAtts;
}

/*
 rectForCharacterIndex: method from:
    http://www.cocoabuilder.com/archive/message/cocoa/2005/3/31/131832
    SUBJECT: Re: boundingRectForGlyphRange oddness - what on earth?
    FROM: Keith Blount
    DATE: Thu Mar 31 01:30:08 2005
*/

- (NSRect)rectForCharacterIndex:(int)charIndex
{
	NSLayoutManager *layoutManager = [self layoutManager];
	NSTextContainer *textContainer = [self textContainer];
	unsigned rectCount;
	
	if  ( charIndex < 0 ) 
		return NSZeroRect; 
	
	NSRectArray rectArray = [layoutManager rectArrayForCharacterRange:NSMakeRange(charIndex,1)
		withinSelectedCharacterRange:NSMakeRange(NSNotFound,0) inTextContainer:textContainer rectCount:&rectCount];
	
	if (rectCount)
		return rectArray[0];
	
	return NSZeroRect;
}

// aviod our insertText menthod
- (void) insertTextNow: (NSString *) str;
{
	[super insertText: str];
}

/*
- (void)copy:(id)sender
{
NSLog(@"copying . . . gran: %d", [self selectionGranularity]);

	[[self sharedData] setBufferGranularity: [self selectionGranularity]];
	
	[super copy: sender];
}

- (void)cut:(id)sender
{
NSLog(@"cutting . . . gran: %d", [self selectionGranularity]);

	[[self sharedData] setBufferGranularity: [self selectionGranularity]];
	
	[super cut: sender];
}
*/

- (BOOL)writeSelectionToPasteboard:(NSPasteboard *)pboard type:(NSString *)type
{
	if ( [type isEqualToString: viAllOverPasteboardType] )
	{
		NSPasteboard *pb = [NSPasteboard generalPasteboard];
		
		// add our type
		if ( [self selectionGranularity] == NSSelectByParagraph )
		{
//NSLog(@"time to add our type");
			[pb setString:@"YES" forType:viAllOverPasteboardType];
		}
		else
		{
			[pb setString:@"NO" forType:viAllOverPasteboardType];
		}
	}
	
	return [super writeSelectionToPasteboard:pboard type:type];
}

- (BOOL)writeSelectionToPasteboard:(NSPasteboard *)pboard types:(NSArray *)types
{
	// inject our type into the list of pasteboard types
	NSMutableArray *newTypes = [NSMutableArray arrayWithObject: viAllOverPasteboardType];
	[newTypes addObjectsFromArray: types];
	
	return [super writeSelectionToPasteboard:pboard types:newTypes];
}

// new commands

- (void)vAO_insertMode:(id)sender
{
	[[self sharedData] setCommandMode: FALSE];
	
	// turn off command recording
	//[[self sharedData] setRecordCommand: FALSE];

	// turn off visual mode
	[[self sharedData] setVisualMode: FALSE]; 

    [self setNeedsDisplay:YES];
	
}

// this way we can switch from visual mode to insert mode without switching to command mode first
- (void)vAO_insertModeAndModifySelection:(id)sender
{
	[self vAO_insertMode:sender];
}

- (void)vAO_commandMode:(id)sender;
{
	[[self sharedData] setCommandMode: TRUE];

    [self setNeedsDisplay:YES];
	
}

- (void)vAO_replaceChar:(id)sender
{
	[[self sharedData] setSpecialMode: @"r"]; 
}

- (void)vAO_lineFindForward:(id)sender
{
	[[self sharedData] setSpecialMode: @"f"]; 
}

- (void)vAO_lineFindForwardAndModifySelection:(id)sender
{
	[[self sharedData] setSpecialMode: @"f"]; 
}

- (void)vAO_lineFindBackward:(id)sender
{
	[[self sharedData] setSpecialMode: @"F"]; 
}

- (void)vAO_lineFindBackwardAndModifySelection:(id)sender
{
	[[self sharedData] setSpecialMode: @"F"]; 
}

- (void)vAO_lineFindMinus1Forward:(id)sender
{
	[[self sharedData] setSpecialMode: @"t"]; 
}

- (void)vAO_lineFindMinus1ForwardAndModifySelection:(id)sender
{
	[[self sharedData] setSpecialMode: @"t"]; 
}

- (void)vAO_lineFindMinus1Backward:(id)sender
{
	[[self sharedData] setSpecialMode: @"T"]; 
}

- (void)vAO_lineFindMinus1BackwardAndModifySelection:(id)sender
{
	[[self sharedData] setSpecialMode: @"T"]; 
}

- (void)vAO_repeatLastEdit:(id)sender;
{
	// don't need to record anything now
	[[self sharedData] setRecordCommand: FALSE]; 
	
	// lock
	[[self sharedData] setRepeatingLastEdit: TRUE]; 
	
	NSString *lastCommand = [[self sharedData] recordedCommand];
	int i, commandCount = [lastCommand length];
	
	for ( i = 0; i < commandCount; i++ )
	{
		[self insertText: [lastCommand substringWithRange: NSMakeRange(i,1)]];
	}
	
	// un-lock
	[[self sharedData] setRepeatingLastEdit: FALSE]; 

	// make sure we return to command mode
	[self vAO_commandMode: sender];
}

- (void)vAO_visualMode:(id)sender
{
	// turn on visual mode
	[[self sharedData] setVisualMode: @"v"]; 
	
	// select the character under the cursor for the start of our selection
	if ( [self selectedRange].length == 0 )
		[self setSelectedRange: NSMakeRange([self selectedRange].location, 1)];

//NSLog(@"visual mode");
}

- (void)vAO_visualLineMode:(id)sender
{
	// turn on visual mode
	[[self sharedData] setVisualMode: @"V"]; 
	
	// set selections to line
	[self setSelectionGranularity:NSSelectByParagraph];
	
	// select the character under the cursor for the start of our selection
	[self setSelectedRange: NSMakeRange([self selectedRange].location, 1)];
}

-(void)vAO_openFindPanel:(id)sender;
{
	NSControl *c = [[NSControl alloc] initWithFrame:NSZeroRect];
	[c setTag: NSFindPanelActionShowFindPanel];
	[self performFindPanelAction: c];
	[c release];
}

-(void)vAO_findNext:(id)sender;
{
	NSControl *c = [[NSControl alloc] initWithFrame:NSZeroRect];
	[c setTag: NSFindPanelActionNext];
	[self performFindPanelAction: c];
	[c release];
}

-(void)vAO_findPrevious:(id)sender;
{
	NSControl *c = [[NSControl alloc] initWithFrame:NSZeroRect];
	[c setTag: NSFindPanelActionPrevious];
	[self performFindPanelAction: c];
	[c release];
}

-(void)vAO_findNextSelection:(id)sender;
{
	NSRange lookHere = [self selectedRange];

	if ( lookHere.length == 0 )
	{
		// no selection, select the word under the cursor
		NSRange newSelection = [self selectionRangeForProposedRange:lookHere granularity:NSSelectByWord];
		[self setSelectedRange:newSelection];
	}
		
	NSControl *c = [[NSControl alloc] initWithFrame:NSZeroRect];
	[c setTag: NSFindPanelActionSetFindString];
	[self performFindPanelAction: c];
	[c release];
	
	[self vAO_findNext:nil];
}

-(void)vAO_findPreviousSelection:(id)sender;
{
	NSRange lookHere = [self selectedRange];

	if ( lookHere.length == 0 )
	{
		// no selection, select the word under the cursor
		NSRange newSelection = [self selectionRangeForProposedRange:lookHere granularity:NSSelectByWord];
		[self setSelectedRange:newSelection];
	}
		
	NSControl *c = [[NSControl alloc] initWithFrame:NSZeroRect];
	[c setTag: NSFindPanelActionSetFindString];
	[self performFindPanelAction: c];
	[c release];
	
	[self vAO_findPrevious:nil];
}

// for implementing "w"
// words delimited by spaces, newlines, and punction
- (void)vAO_wordForward:(id)sender;
{
	[self vAO_wordMovementModifySelection: NO ignorePunctuation: NO];
}

- (void)vAO_wordForwardAndModifySelection:(id)sender;
{
	[self vAO_wordMovementModifySelection: YES ignorePunctuation: NO];
}

// for implementing "W"
// words delimited by spaces or newlines only
- (void)vAO_wordForwardIgnorePunctuation:(id)sender
{
	[self vAO_wordMovementModifySelection: NO ignorePunctuation: YES];
}

- (void)vAO_wordForwardIgnorePunctuationAndModifySelection:(id)sender;
{
	[self vAO_wordMovementModifySelection: YES ignorePunctuation: YES];
}

// for implementing "b"
- (void)vAO_wordBackward:(id)sender
{
	[self vAO_wordMovementModifySelection: NO ignorePunctuation: NO backward: YES];
}

- (void)vAO_wordBackwardAndModifySelection:(id)sender;
{
	[self vAO_wordMovementModifySelection: YES ignorePunctuation: NO backward: YES];
}

// for implementing "B"
- (void)vAO_wordBackwardIgnorePunctuation:(id)sender
{
	[self vAO_wordMovementModifySelection: NO ignorePunctuation: YES backward: YES];
}

- (void)vAO_wordBackwardIgnorePunctuationAndModifySelection:(id)sender;
{
	[self vAO_wordMovementModifySelection: YES ignorePunctuation: YES backward: YES];
}

// for implementing "e"
- (void)vAO_wordForwardToEnd:(id)sender;
{
	[self vAO_wordMovementModifySelection: NO ignorePunctuation: NO backward: NO moveToEnd: YES];
}

- (void)vAO_wordForwardToEndAndModifySelection:(id)sender;
{
	[self vAO_wordMovementModifySelection: YES ignorePunctuation: NO backward: NO moveToEnd: YES];
}

// for implementing "E"
- (void)vAO_wordForwardToEndIgnorePunctuation:(id)sender
{
	[self vAO_wordMovementModifySelection: NO ignorePunctuation: YES backward: NO moveToEnd: YES];
}

- (void)vAO_wordForwardToEndIgnorePunctuationAndModifySelection:(id)sender;
{
	[self vAO_wordMovementModifySelection: YES ignorePunctuation: YES backward: NO moveToEnd: YES];
}


- (void)vAO_wordMovementModifySelection: (bool)modify ignorePunctuation: (BOOL)ignore;
{
	[self vAO_wordMovementModifySelection:modify ignorePunctuation:ignore backward: false];
}

- (NSRange)getCurrentWordIgnorePunctuation: (BOOL)ignore;
{
	return [self getCurrentWordIgnorePunctuation:ignore range: [self selectedRange]];
}

- (NSRange)getCurrentWordIgnorePunctuation: (BOOL)ignore range: (NSRange)startHere;
{
	NSMutableCharacterSet * notWordSet = [[NSCharacterSet whitespaceAndNewlineCharacterSet] mutableCopy];
	
	NSMutableCharacterSet * puncSet = [[NSCharacterSet punctuationCharacterSet] mutableCopy];
	[puncSet formUnionWithCharacterSet: [NSCharacterSet symbolCharacterSet]];
	
	NSCharacterSet * wordSet = [notWordSet invertedSet];

	
	if ( !ignore ) // not ignoring punctuation
	{
		[notWordSet formUnionWithCharacterSet: puncSet];
	}
	
	
	unsigned int strLength = [[self string] length];
	NSRange lookHere = startHere;
	NSRange itsHere = NSMakeRange(NSNotFound,0);
	BOOL zero = NO;
	
if (DEBUG) NSLog(@"word here?: %@", NSStringFromRange(startHere));
	
	if ( startHere.location >= 0 && startHere.location < strLength && [wordSet characterIsMember: [[self string] characterAtIndex: startHere.location]] )
	{
		NSCharacterSet *notSet;
		
		// what set is this word in
		if ( !ignore && [puncSet characterIsMember: [[self string] characterAtIndex: startHere.location]] )
		{
//NSLog(@"this is punc.");			
			notSet = [puncSet invertedSet];
		}
		else
			notSet = notWordSet;
		
//NSLog(@"in a word");
		// find the beggining of the word
		BOOL alreadyHere = true;
		
		
		while (  ![notSet characterIsMember: [[self string] characterAtIndex: lookHere.location]] )
		{
			alreadyHere = false;
			
			if ( lookHere.location == 0 ) 
			{
				zero = YES;
				break;
			}
							
//NSLog(@" not here: %@", NSStringFromRange(lookHere));
			lookHere.location -= 1;
//NSLog(@" look here: %@", NSStringFromRange(lookHere));

		}
		
//NSLog(@" look here: %@", NSStringFromRange(lookHere));
		if ( zero )
			itsHere.location = 0;
		else if ( alreadyHere )
			itsHere.location = lookHere.location;
		else
			itsHere.location = lookHere.location + 1;
		
//NSLog(@" that starts here: %@", NSStringFromRange(itsHere));
		lookHere = startHere;
		
		// find the end of the word
		while ( lookHere.location < strLength && ![notSet characterIsMember: [[self string] characterAtIndex: lookHere.location]] )
		{
//NSLog(@" not here: %@", NSStringFromRange(lookHere));
			lookHere.location += 1;
		}
//NSLog(@" that ends here: %@", NSStringFromRange(lookHere));
		
		itsHere.length = lookHere.location - itsHere.location;
		
		if ( itsHere.length == 0 )
			itsHere.length = 1;
			
//NSLog(@"found word here: %@", NSStringFromRange(itsHere));
	}

	[notWordSet release];
	[puncSet release];
	
	return itsHere;
}

- (void)vAO_wordMovementModifySelection: (bool)modify ignorePunctuation: (BOOL)ignore backward: (BOOL)backward;
{
	[self vAO_wordMovementModifySelection: modify ignorePunctuation: ignore backward: backward moveToEnd: FALSE];
}

- (void)vAO_wordMovementModifySelection: (bool)modify ignorePunctuation: (BOOL)ignore backward: (BOOL)backward moveToEnd: (BOOL)end;
{
	unsigned int strLength = [[self string] length];
	unsigned searchMask = NSCaseInsensitiveSearch;
	NSRange startHere;
	NSRange theWord;
	NSRange here;
	
	startHere = here = [self selectedRange];
	
	if ( modify )
	{
		if ( backward )
		{
			startHere.location = startHere.location - 1;
		}
		else
		{
			startHere.location = startHere.location + startHere.length;
		}
		
		startHere.length = 1;
	}
	
	theWord = [self getCurrentWordIgnorePunctuation:ignore range: startHere];
	
//if ( DEBUG ) NSLog(@"theWord: %@", NSStringFromRange(theWord));
	if ( theWord.location != NSNotFound ) 
	{
		/*if ( backward )
		{
			startHere.location = theWord.location - 1;
		}
		else
		{
			startHere.location = theWord.location + theWord.length;
		}*/
		startHere = theWord;
//NSLog(@"look for next word here: %@", NSStringFromRange(startHere));
	}
	else
		startHere = [self selectedRange];

	if ( backward )
	{
		startHere.location = startHere.location - 1;
	}
	else
	{
		startHere.location = startHere.location + startHere.length;
	}
	startHere.length = 1;
	
	
//NSLog(@"theWord.loc: %@, here.loc %@, backward: %d, end: %d", NSStringFromRange(theWord), NSStringFromRange(here), backward, end );
	if ( 
		( !backward && !end ) || 
		( backward && ( theWord.location != NSNotFound && theWord.location == here.location ) || theWord.location == NSNotFound) ||
		( end && ( theWord.location != NSNotFound && theWord.location + theWord.length - 1 == here.location ) || theWord.location == NSNotFound) 
	)
	{
		// find the next word
		do
		{
//NSLog(@"looking for next word here: %@", NSStringFromRange(startHere));
			theWord = [self getCurrentWordIgnorePunctuation:ignore range: startHere];

			if ( backward )
				startHere.location -= 1;
			else
				startHere.location += 1;
			
			if ( startHere.location < 0 || startHere.location > strLength )
			{
				// don't want to go off the end
				break;
			}
		}
		while ( theWord.location == NSNotFound ) ;
	}
	
	if ( theWord.location == NSNotFound ) 
	{
		// no more words, go to the end/beginning
		if ( backward )
			[self select_new_Range: NSMakeRange(0, 1) forSelectionModification: modify];
		else
			[self select_new_Range: NSMakeRange(strLength, 1) forSelectionModification: modify];
	}
	else
	{
		// which part of the word to go to
		if ( end )
		{
			// the end
			theWord.location = theWord.location + theWord.length - 1;
		}
		else
		{
			// begginning
		}
		
		theWord.length = 0;

		[self select_new_Range:theWord forSelectionModification:modify];
	}

}


- (NSRange)get_new_lookHere_location_forSelectionModification: (BOOL)modify;
{
	return [self get_new_lookHere_location_forSelectionModification:modify backward:false];
}

- (NSRange)get_new_lookHere_location_forSelectionModification: (BOOL)modify backward: (BOOL)backward;
{
	unsigned int strLength = [[self string] length];

	NSRange lookHere = [self selectedRange];
	
	// if there is already a selection and we are modifying start look after the selection
	/*
	if ( modify ) //&& lookHere.length > 0 ) 
	{
		NSSelectionAffinity affin = [self selectionAffinity];
		
		if ( affin == NSSelectionAffinityDownstream ) // towards bottom
		{
				NSLog(@"downstream");
			lookHere.location = lookHere.location + lookHere.length;
		}
		else if ( affin == NSSelectionAffinityUpstream ) // towards top
		{
			//lookHere.location = lookHere.location + lookHere.length;
				NSLog(@"upstream");
		}
	}
	*/
	
	if ( !backward )
	{
		// check everything from the cursor to the end
		lookHere.length = strLength - lookHere.location; 
	}
	else
	{
if (DEBUG) NSLog(@"looking backward");
		lookHere.length = lookHere.location;
		lookHere.location = 0;
	}
	
	return lookHere;
}

- (void)select_new_Range: (NSRange)nextSpot forSelectionModification: (BOOL)modify;
{
		if ( !modify )
			nextSpot.length = 0;
		else
		{
			
			NSSelectionAffinity affin = [self selectionAffinity];
			
			if ( affin == NSSelectionAffinityDownstream ) // towards bottom
			{
				if (DEBUG) NSLog(@"downstream"); // nothing to do
			}
			else if ( affin == NSSelectionAffinityUpstream ) // towards top
			{
				if (DEBUG) NSLog(@"upstream"); // nothing to do
			}
// bummer, it's not the mark
//NSLog(@"modifing selection: %@", NSStringFromRange([self markedRange]));

			nextSpot = NSUnionRange([self selectedRange], nextSpot);
		}
		
		//if ( [[[self sharedData] visualMode] isEqualToString:@"V"] )
		//	nextSpot = [self selectionRangeForProposedRange:nextSpot granularity:NSSelectByParagraph];
		
		[self setSelectedRange: nextSpot affinity: NSSelectionAffinityDownstream stillSelecting: NO ];
}

/*
- (void)setSelectedRanges:(NSRange)charRange affinity:(NSSelectionAffinity)affinity stillSelecting:(BOOL)flag
{
}
*/

- (void)setSelectedRange:(NSRange)charRange affinity:(NSSelectionAffinity)affinity stillSelecting:(BOOL)flag
{
			// the mouse made a selection switch to visual mode
			if ( flag && [[self sharedData] commandMode] && charRange.length > 0 ) 
			{
				if ( [self selectionGranularity] == NSSelectByParagraph )
					[[self sharedData] setVisualMode: @"V"]; 
				else
					[[self sharedData] setVisualMode: @"v"]; 
			}
			else if ( flag && [[self sharedData] commandMode] )
			{
				[[self sharedData] setVisualMode: FALSE];
			}
				
			if ( affinity == NSSelectionAffinityDownstream ) // towards bottom
			{
				//NSLog(@"setting the selection affinity to downstream"); // nothing to do
			}
			else if ( affinity == NSSelectionAffinityUpstream ) // towards top
			{
				//NSLog(@"setting the selection affinity to upstream"); // nothing to do
			}

//NSLog(@"range: %@ stillSelecting: %d", NSStringFromRange(charRange), flag);
//NSLog(@"typing atts: %@", [self typingAttributes]);
//NSLog(@"mark: %@", NSStringFromRange([self markedRange]));

	// makes visual line mode work a little better
	if ( [[[self sharedData] visualMode] isEqualToString:@"V"] )
		charRange = [self selectionRangeForProposedRange:charRange granularity:NSSelectByParagraph];

	
	[super setSelectedRange:charRange affinity:affinity stillSelecting:flag];
	
	if ( [[[self sharedData] visualMode] isEqualToString:@"V"] )
		[self setSelectionGranularity:NSSelectByParagraph];

}

- (NSRange)selectionRangeForProposedRange:(NSRange)proposedSelRange granularity:(NSSelectionGranularity)granularity
{
	NSSelectionGranularity g;
	/*
	if ( [[[self sharedData] visualMode] isEqualToString:@"V"] )
		g = NSSelectByParagraph;
	else */
		g = granularity;

	[super selectionRangeForProposedRange: proposedSelRange granularity: g];
}


static NSMapTable *_instanceMap = nil;

+ (NSMapTable *) _instanceMap;
{
	if( nil == _instanceMap )
	{
		_instanceMap = NSCreateMapTable( NSNonRetainedObjectMapKeyCallBacks, NSObjectMapValueCallBacks, 4 );
	}
	
	return _instanceMap;
}

- (id)sharedData;
{
	return [[self class] sharedData];
}

+ (id)sharedData;
{
	vAOData *sharedInstance = NSMapGet( [[self class] _instanceMap], self);

    if (!sharedInstance) 
	{
        sharedInstance = [[vAOData alloc] init];
		NSMapInsert( [[self class] _instanceMap], self, sharedInstance);
//NSLog(@"self: %@, instance: %@", self, sharedInstance);
    }
	
    return sharedInstance;
}

- (void)dealloc 
{
	// clean up after ourselves
	NSMapRemove([[self class] _instanceMap], self);
	
	[super dealloc];
}


- (NSColor *) getColorWithName: (NSString *)colorName;
{
	NSDictionary *colorDict = nil;
	
	NSDictionary *userColors = [[[self class] getUserDefaultsDict] objectForKey:@"color"];
	
//NSLog(@"colorName: %@", colorName);
//NSLog(@"colorDict: %@", userColors);
	if ( userColors )
	{
		colorDict = [userColors objectForKey:colorName];
	}
	
	if ( nil == colorDict )
	{
		NSDictionary *defaulColors = [[[self class] getDefaultsDict] objectForKey:@"color"];
		
		colorDict = [defaulColors objectForKey:colorName];
	}

//NSLog(@"colorDict: %@", colorDict);
//NSLog(@"colors: %@", [[vAOData getDefaultCommandDict] objectForKey:@"color"]);
	
	NSColor *thisColor = [NSColor colorWithCalibratedRed:[[colorDict objectForKey:@"red"] floatValue]
		green:[[colorDict objectForKey:@"green"] floatValue]
		blue:[[colorDict objectForKey:@"blue"] floatValue]
		alpha:1.0];

	return thisColor;
}

static NSMutableDictionary *defaults = nil, *userDefaults = nil;

+ (NSDictionary *)getDefaultsDict; 
{
    //static NSMutableDictionary *keyCommands = NULL;
	//NSDictionary *keyCommands1 = nil, *keyCommands2 = nil;
    
    if ( nil == defaults )
    {
		// load movement key
		
		// load from bundle
		NSBundle * b = [NSBundle bundleForClass: [vAOData class]];
		
		defaults = [[NSDictionary dictionaryWithContentsOfFile: 
			[b pathForResource:@"defaults" ofType:@"plist"]] retain];
		// don't release it, its static
		
		//NSLog(@"trying to load movement keys dict: %@", [b pathForResource:@"movementKeys" ofType:@"plist"]);
		
		
		if ( defaults ) {
			//NSLog(@"loaded default dict");
		} else {
			NSLog(@"failed loading default dict");
		}
		
    }
	
	return (NSDictionary *) defaults;
}

- (NSDictionary *)getDefaultCommandDict; 
{
	return [[[self class] getDefaultsDict] objectForKey: @"bindings"];
}

- (NSDictionary *)getUserCommandDict; 
{
	return [[[self class] getUserDefaultsDict] objectForKey: @"bindings"];
}

+ (NSDictionary *)getUserDefaultsDict; 
{
    
	// check the mod time of the users command file
    NSFileManager *fm = [NSFileManager defaultManager];
	
	NSString *fullPath = [@"~/Library/Preferences/org.dabble.viAllOver.plist" stringByExpandingTildeInPath];
	
    NSDictionary *thisAttr = [fm fileAttributesAtPath:fullPath traverseLink:YES];
	
    NSDate *thisModDate = [thisAttr objectForKey:NSFileModificationDate];
	
	//NSLog(@"checking: %@ with: %@", thisModDate, [[vAOData sharedData] lastUpdate]);
	
	if ( [thisModDate compare: [[self sharedData] lastUpdate]] == NSOrderedDescending) 
	{
		
		//NSLog(@"trying to load user's commands dict.");
		
		// now check and see if the user has anything to add
		userDefaults = [[NSDictionary dictionaryWithContentsOfFile: fullPath] retain];
		
		if ( userDefaults ) 
		{
			//NSLog(@"loaded user dict");
		} 
		else 
		{
			NSLog(@"failed loading user defaults.");
		}
		
		[[self sharedData] setLastUpdate: [NSDate date]];
    }
	
	return (NSDictionary *) userDefaults;
}


@end









