//
//  vAOTextView.h
//  viAllOver
//
//  Copyright (c) 2004-2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 


#import <Cocoa/Cocoa.h>

#import "vAOData.h"

@interface vAOTextView : NSTextView
{
    // no instance variables, it's poseable.
}

- (NSRect)rectForCharacterIndex:(int)charIndex;

- (NSRect)getInsertionPointRect;
- (int)getDefaultCaretWidth;
- (NSRect)getStandardInsertionPointRect;

- (void) insertTextNow: (NSString *) str;

// new commands
- (void)vAO_insertMode:(id)sender;
- (void)vAO_commandMode:(id)sender;
- (void)vAO_repeatLastEdit:(id)sender;
- (void)vAO_wordForward:(id)sender;
- (void)vAO_wordForwardAndModifySelection:(id)sender;
- (void)vAO_wordForwardIgnorePunctuation:(id)sender;
- (void)vAO_wordForwardIgnorePunctuationAndModifySelection:(id)sender;

// new command support
- (NSRange)getCurrentWordIgnorePunctuation: (BOOL)ignore;
- (NSRange)getCurrentWordIgnorePunctuation: (BOOL)ignore range: (NSRange)startHere;

- (void)vAO_wordMovementModifySelection: (bool)modify ignorePunctuation: (BOOL)ignore;
- (void)vAO_wordMovementModifySelection: (bool)modify ignorePunctuation: (BOOL)ignore backward: (BOOL)backward;
- (void)vAO_wordMovementModifySelection: (bool)modify ignorePunctuation: (BOOL)ignore backward: (BOOL)backward moveToEnd: (BOOL)end;

- (NSRange)get_new_lookHere_location_forSelectionModification: (BOOL)modify;
- (NSRange)get_new_lookHere_location_forSelectionModification: (BOOL)modify backward: (BOOL)backward;
- (void)select_new_Range: (NSRange)nextSpot forSelectionModification: (BOOL)modify;

- (id)sharedData;
+ (id)sharedData;

- (NSColor *) getColorWithName: (NSString *)colorName;

+ (NSDictionary *)getDefaultsDict; 
- (NSDictionary *)getDefaultCommandDict;
+ (NSDictionary *)getUserDefaultsDict; 
- (NSDictionary *)getUserCommandDict;

@end
