//
//  vAOData.h
//  viAllOver
//
//  Copyright (c) 2004-2007 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 


#import <Cocoa/Cocoa.h>
//#import <Foundation/Foundation.h>

//BOOL DEBUG = TRUE;

#import "vAOCommand.h"

@class vAOCommand;

@interface vAOData : NSObject {
	BOOL commandMode;
	vAOCommand *command;
	NSString *specialMode;
	NSString *visualMode;
	BOOL recordCommand;
	NSString *recordedCommand;
	BOOL repeatingLastEdit;
	BOOL insertionPointLock;
	NSString * replaceChar;
	int repeatTimes;
	NSRect oldDotRect;
	NSRect oldInsertionPointRect;
	NSDate *lastUpdate;
	NSRange mark;
	NSSelectionGranularity bufferGranularity;
}

//+ (id) sharedData;

- (BOOL) commandMode;
- (void) setCommandMode: (BOOL) val;

- (vAOCommand *) command;
- (void) setCommand: (vAOCommand *) val;

- (NSString *) specialMode;
- (void) setSpecialMode: (NSString *) val;
- (BOOL) isSpecialMode: (NSString *) val;

- (NSString *) visualMode;
- (void) setVisualMode: (NSString *) val;

- (BOOL) repeatingLastEdit;
- (void) setRepeatingLastEdit: (BOOL) val;

- (BOOL) recordCommand;
- (void) setRecordCommand: (BOOL) val;
- (void) addToRecordedCommand: (NSString *) aString;
- (void) resetRecordedCommand;
- (NSString *) recordedCommand;
- (NSString *) popFromRecordedCommand;

- (BOOL) insertionPointLock;
- (void) setInsertionPointLock: (BOOL) val;

- (NSString *) replaceChar;
- (void) setReplaceChar: (NSString *) val;

- (void) setRepeatTimes: (int) times;
- (int) repeatTimes;

- (NSRect) oldInsertionPointRect;
- (void) setOldInsertionPointRect: (NSRect) rect;

- (NSRect) oldDotRect;
- (void) setOldDotRect: (NSRect) rect;

- (NSSelectionGranularity) bufferGranularity;
- (void) setBufferGranularity: (NSSelectionGranularity) gran;

- (NSRange) mark;
- (void) setMark: (NSRange) rect;

- (NSDate *) lastUpdate;
- (void) setLastUpdate: (NSDate *) when;


@end
