//
//  vAOCommand.m
//  viAllOver
//
//  Copyright (c) 2005 Matt O'Brien. All rights reserved.
//
/*
 This file is part of viAllOver.
 
 viAllOver is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 viAllOver is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with viAllOver; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */ 


#import "vAOCommand.h"


@implementation vAOCommand

BOOL DEBUG = FALSE;

- (id)init: (NSString *) str; {
	
	self = [super init];
    if (self) {
		
		cmd = [str retain];
		
		type = [[self getType] retain];
	
		if ( nil == type ) {
			return nil;
		} else {
			return self;
		}
	}
		
	return self;
}

- (NSString *)getType; {
	
	// search the user dict for the command first
	NSDictionary * dict = [vAOData getUserCommandDict];
	
	int i = 0, j = 0;
	
	for ( j = 2; j > 0; j-- ) {
		NSArray * keys = [dict allKeys];

		for ( i = [keys count] - 1; i >= 0; i-- ) {
			
			//NSLog(@"checking: %@", [keys objectAtIndex:i]);
			
			if ( [[dict objectForKey: [keys objectAtIndex: i]] objectForKey: cmd] ) {
				type = [keys objectAtIndex: i];
				//NSLog(@"we found out type: %@", type);

				if (DEBUG) NSLog(@"cmd: %@ with type: %@", cmd, type);
				
				return type;
			}
		}
		// now lets use the default dict now
		dict = [vAOData getDefaultCommandDict];
	}
	
	return nil;
}

- (BOOL)initAndDoItTo: (id) textview withChar: (NSString *) aString; {
	
	if ( ![self init: aString] ) {
		return TRUE;
	}
	
	return [self doItTo: textview];

}

- (NSString *) character; {
	return cmd;
}

- (id)getAction {
	
	id action = [[[vAOData getUserCommandDict] objectForKey: type] objectForKey: cmd];	
	
	if ( nil == action ) {
		action = [[[vAOData getDefaultCommandDict] objectForKey: type] objectForKey: cmd];
	} 
	
	return action;
}


- (BOOL)isCommand {
	return ( [type compare: @"command"] == NSOrderedSame );
}

- (BOOL)isMovement {
	return ( [type compare: @"movement"] == NSOrderedSame );
}

- (BOOL)isOther {
	return ( [type compare: @"other"] == NSOrderedSame );
}

- (BOOL)isR; {
	return ( [cmd isEqualToString: @"r"] );
}

- (BOOL) doItTo: (id) textview; {
	//NSLog(@"[COMMAND] new char: %@", aString);

	// check and see if we got a command
	if ( [self isCommand] ) {

		if ( [[self character] isEqualToString: [[[vAOData sharedData] command] character]] ) {
			// double commands!!
			int i, times = [[vAOData sharedData] repeatTimes];
			
			[textview doCommandBySelector: @selector(selectLine:)];

			// select a line for each additional. "3dd" this would do 2 more.
			for ( i = (times)?times:1; i > 1; i-- ) {
				[textview doCommandBySelector: @selector(moveDownAndModifySelection:)];
			}

			// do the command
			[self doActionTo: textview];

			// all done here, need clean up.
			return FALSE;
		}

		// save it
		[[vAOData sharedData] setCommand: self];
		
		// we are done for now
		return TRUE;
	}

	// check for a movement
	if ( [self isMovement] ) {
		// it's time to do what ever we have in the que
		[self doActionTo: textview thisManyTimes: [[vAOData sharedData] repeatTimes] withCommand: [[vAOData sharedData] command]];
	}

	// check for an other
	if ( [self isOther] ) {
		// make it so
		if ( [self isR] ) {
			[self doActionTo: textview thisManyTimes: 1];
			return TRUE;
		} else {
			[self doActionTo: textview thisManyTimes: [[vAOData sharedData] repeatTimes]];
		}
		
	}
	
	return FALSE;
}


- (void)doActionTo: (id) txtarea {
	[self doActionTo: txtarea thisManyTimes: 0 withCommand: NULL]; 
}

- (void)doActionTo: (id) txtarea thisManyTimes: (int) times; {
	[self doActionTo: txtarea thisManyTimes: times withCommand: NULL]; 
}

- (void)doActionTo: (id) textview thisManyTimes: (int) times withCommand: (vAOCommand *) command; {
	
   // look-up the command
	id theAction = [self getAction];
	
	// check the command, if not try the last char
	if ( !theAction ) {
		return;
	}
	
	// check and see if its an alias
	if ( [theAction isKindOfClass: [NSString class]] && [self isAlias: theAction] ) {
		// what to do?
		unsigned int i, strLen = [theAction length];
		
		for ( i = 0; i < strLen; i++ ) {
			[[vAOCommand alloc] initAndDoItTo: textview 
				withChar: [theAction substringWithRange: NSMakeRange(i, 1)]];
		}
		
		return;
	}
	
	// there is always at least one selector for a command
	int selectorListCount = 1;
	
	// is it an array of selectors
	if ( [theAction isKindOfClass: [NSArray class]] ) {
		selectorListCount = [theAction count];
	}
	
	// we need somewhere to put the selectors
	SEL selectorList[selectorListCount];
	selectorList[0] = nil;
	
	
	if ( [theAction isKindOfClass: [NSArray class]] )
	{
		// look up the selectors
		int i;
		
		for ( i = 0; i < selectorListCount; i++ )
		{
			if (DEBUG)
				NSLog(@"[COMMAND] %d: %d %@: %@", i, [[vAOData sharedData] repeatTimes], 
				  [self character], [theAction objectAtIndex: i]);
			
			selectorList[i] = NSSelectorFromString([theAction objectAtIndex: i]);
		}
	}
	else if ( [theAction isKindOfClass: [NSString class]] )
	{
		if (DEBUG) 
			NSLog(@"[COMMAND] %d %@: %@", [[vAOData sharedData] repeatTimes], 
			  [self character], theAction);
		
		selectorList[0] = NSSelectorFromString(theAction);
	}
	
	// if we found a selector lets do it
	if ( selectorList[0] )
	{
		if ( command ) {
			// set the mark
			if (DEBUG) NSLog(@"setting the mark");
			[textview doCommandBySelector: NSSelectorFromString(@"setMark:")];
		}
		
		int i, rt = (times)?times:1 ;
		
		// now repeat
		for ( i = 0; i < rt; i++ )
		{
			int j;
			for ( j = 0; j < selectorListCount; j++ )
			{
				if ( selectorList[j] )
				{
					if (DEBUG) 
						NSLog(@"running selector: %d/%d %@", j + 1, selectorListCount,
						  NSStringFromSelector(selectorList[j]));
					
					[textview doCommandBySelector: selectorList[j]];
				}
			}
		}
		
		if ( command ) {
			// set the mark
			if (DEBUG) 
				NSLog(@"selecting to mark");
			[textview doCommandBySelector: @selector(selectToMark:)];
			
			// do the command
			[command doActionTo: textview];
		}
		
		
	}
	else
	{
		return;// FALSE;
	}
	
	return;// TRUE;
}	

- (BOOL)isSelector: (NSString *)str; {
	
	if ( [str hasSuffix: @":"] ) {
		return TRUE;
	}
	
	return FALSE;
}

- (BOOL)isAlias: (NSString *)str; {
	return ![self isSelector: str];
}

- (void)dealloc {
	[cmd release];
	[type release];
	
	cmd = nil;
	type = nil;
	
	[super dealloc];
}


@end
